/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.script.pack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.property.BiomePropertyManager;
import me.superckl.api.biometweaker.property.Property;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.util.WarningHelper;
import net.minecraft.world.biome.Biome;

public class PropertyRangeBiomePackage
extends BiomePackage {
    private final Property<? extends Number> property;
    private final float lowBound;
    private final float highBound;

    public PropertyRangeBiomePackage(String property, float lowBound, float highBound) {
        Property<?> prop = BiomePropertyManager.findProperty(property);
        if (prop == null) {
            throw new IllegalArgumentException("No property found for name " + property);
        }
        if (!Number.class.isAssignableFrom(prop.getTypeClass())) {
            throw new IllegalArgumentException("Property " + property + " is not a numeric value!");
        }
        this.property = (Property)WarningHelper.uncheckedCast(prop);
        this.lowBound = lowBound;
        this.highBound = highBound;
    }

    @Override
    public Iterator<Biome> getIterator() {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (Biome biome : Biome.field_185377_q) {
            float value = this.property.get(biome).floatValue();
            if (!(this.lowBound <= value) || !(value <= this.highBound)) continue;
            biomes.add(biome);
        }
        return biomes.iterator();
    }

    @Override
    public boolean supportsEarlyRawIds() {
        return false;
    }

    @Override
    public List<Integer> getRawIds() {
        ArrayList<Integer> biomes = new ArrayList<Integer>();
        for (Biome biome : Biome.field_185377_q) {
            float value = this.property.get(biome).floatValue();
            if (!(this.lowBound <= value) || !(value <= this.highBound)) continue;
            biomes.add(Biome.func_185362_a((Biome)biome));
        }
        return biomes;
    }
}

