/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.materialparts;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.materialsystem.MaterialUser;
import com.teamacronymcoders.base.materialsystem.materials.Material;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.materialsystem.parttype.PartType;
import com.teamacronymcoders.base.util.ItemStackUtils;
import com.teamacronymcoders.base.util.TextUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class MaterialPart {
    private Material material;
    private Part part;
    private ResourceLocation textureLocation;
    private boolean colorized;
    private MaterialPartData data;
    private String variant;
    private MaterialUser materialUser;
    private ItemStack itemStack = ItemStack.field_190927_a;

    public MaterialPart(MaterialUser materialUser, Material material, Part part) {
        this(materialUser, material, part, null);
    }

    public MaterialPart(MaterialUser materialUser, Material material, Part part, String variant) {
        this.setMaterial(material);
        this.setPart(part);
        this.materialUser = materialUser;
        if (materialUser != null) {
            this.setTextureLocation(new ResourceLocation(materialUser.getMod().getID(), part.getShortUnlocalizedName()));
        }
        this.colorized = true;
        this.data = new MaterialPartData(this, part.getPartType().getData());
        if (variant != null) {
            this.variant = TextUtils.toSnakeCase(variant);
        }
    }

    public int getId() {
        return this.getMaterialUser().getMaterialPartId(this);
    }

    public String getUnlocalizedName() {
        return this.material.getUnlocalizedName() + "_" + this.part.getShortUnlocalizedName() + (this.variant != null ? "_" + this.variant : "");
    }

    public String getLocalizedName() {
        if (I18n.func_94522_b((String)this.material.getTranslationKey())) {
            String materialDisplayName = I18n.func_74838_a((String)this.material.getTranslationKey());
            return I18n.func_74837_a((String)this.part.getUnlocalizedName(), (Object[])new Object[]{materialDisplayName});
        }
        return I18n.func_74837_a((String)this.part.getUnlocalizedName(), (Object[])new Object[]{this.material.getName()});
    }

    public boolean hasEffect() {
        return this.getMaterial().isHasEffect();
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Part getPart() {
        return this.part;
    }

    public void setPart(Part part) {
        this.part = part;
    }

    public ItemStack getItemStack() {
        if (!ItemStackUtils.isValid(this.itemStack)) {
            this.itemStack = this.getPartType().getItemStack(this);
        }
        return this.itemStack.func_77946_l();
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textureLocation = textureLocation;
    }

    public int getColor() {
        return this.colorized ? this.getMaterial().getColor().getRGB() : -1;
    }

    @Nullable
    public Color getFullColor() {
        return this.colorized ? this.getMaterial().getColor() : null;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    public void setColorized(boolean colorized) {
        this.colorized = colorized;
    }

    public boolean matchesPartType(PartType partType) {
        return this.getPartType() == partType;
    }

    public String getOreDictString() {
        return this.getPart().getOreDictPrefix() + this.getMaterial().getOreDictSuffix();
    }

    public List<String> getAllOreDictStrings() {
        ArrayList allOreDicts = Lists.newArrayList((Object[])new String[]{this.getOreDictString()});
        allOreDicts.addAll(this.part.getAdditionalOreDictNames().stream().map(value -> value + this.material.getOreDictSuffix()).collect(Collectors.toList()));
        return allOreDicts;
    }

    public MaterialPartData getData() {
        return this.data;
    }

    public void setData(MaterialPartData data) {
        this.data = data;
    }

    public void setup() {
        this.getPart().getPartType().setup(this, this.materialUser);
    }

    public MaterialUser getMaterialUser() {
        return this.materialUser;
    }

    public PartType getPartType() {
        return this.getPart().getPartType();
    }
}

