/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.otg;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import rlmixins.handlers.ForgeConfigHandler;
import rlmixins.wrapper.IObjectSpawnerMixin;

@Mixin(value={ObjectSpawner.class})
public abstract class ObjectSpawnerMixin
implements IObjectSpawnerMixin {
    @Shadow(remap=false)
    public boolean processing;
    @Shadow(remap=false)
    @Final
    private LocalWorld world;
    @Shadow(remap=false)
    public boolean saveRequired;
    @Unique
    public final Lock rlmixins$lock = new ReentrantLock();

    @Shadow(remap=false)
    protected abstract void doPopulate(ChunkCoordinate var1);

    @Override
    @Unique
    public Lock rlmixins$getLock() {
        return this.rlmixins$lock;
    }

    @Overwrite(remap=false)
    public void populate(ChunkCoordinate chunkCoord) {
        try {
            if (!this.rlmixins$lock.tryLock(ForgeConfigHandler.server.otgPopulateLockTime, TimeUnit.SECONDS)) {
                throw new RuntimeException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException();
        }
        try {
            if (!this.processing) {
                this.processing = true;
                this.world.cacheBiomesForPopulation(chunkCoord);
                this.doPopulate(chunkCoord);
                this.processing = false;
            } else {
                this.world.invalidatePopulationBiomeCache();
                this.doPopulate(chunkCoord);
                OTG.log((LogMarker)LogMarker.INFO, (String)"Cascading chunk generation detected.", (Object[])new Object[0]);
                if (OTG.getPluginConfig().developerMode) {
                    OTG.log((LogMarker)LogMarker.INFO, (String)Arrays.toString(Thread.currentThread().getStackTrace()), (Object[])new Object[0]);
                }
            }
            this.saveRequired = true;
        }
        finally {
            this.rlmixins$lock.unlock();
        }
        if (chunkCoord.equals((Object)this.world.getSpawnChunk())) {
            this.world.updateSpawnPointY();
        }
    }
}

