/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.otg;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.structures.CustomStructureCache;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import rlmixins.RLMixins;
import rlmixins.handlers.ForgeConfigHandler;
import rlmixins.wrapper.IObjectSpawnerMixin;

@Mixin(value={CustomStructureCache.class})
public abstract class CustomStructureCacheMixin {
    @Shadow(remap=false)
    private LocalWorld world;

    @Shadow(remap=false)
    protected abstract void saveStructureCache();

    @Overwrite(remap=false)
    public void saveToDisk() {
        RLMixins.LOGGER.log(Level.INFO, "OTG Saving structure and pregenerator data.");
        try {
            if (!((IObjectSpawnerMixin)this.world.getObjectSpawner()).rlmixins$getLock().tryLock(ForgeConfigHandler.server.otgSaveToDiskLockTime, TimeUnit.SECONDS)) {
                throw new RuntimeException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException();
        }
        try {
            this.saveStructureCache();
            this.world.getObjectSpawner().saveRequired = false;
        }
        finally {
            ((IObjectSpawnerMixin)this.world.getObjectSpawner()).rlmixins$getLock().unlock();
        }
        RLMixins.LOGGER.log(Level.INFO, "OTG Structure and pregenerator data saved.");
    }
}

