/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.handlers.dregora;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import rlmixins.handlers.ForgeConfigHandler;

public class DregoraScriptHandler {
    private static final ResourceLocation playerBossReg = new ResourceLocation("playerbosses:player_boss");
    private static final ResourceLocation playerBossBiome = new ResourceLocation("openterraingenerator:overworld_abyssal_rift");
    private static final ResourceLocation dragonBossReg = new ResourceLocation("srparasites:sim_dragone");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        ResourceLocation entityId = EntityList.func_191301_a((Entity)entity);
        if (entityId == null || !ForgeConfigHandler.getDregoraArrowAllowedEntities().contains(entityId)) {
            return;
        }
        if (!(entity.func_184614_ca().func_77973_b() instanceof ItemBow)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData();
        if (tag.func_74762_e("ArrowCheck") != 1) {
            tag.func_74768_a("ArrowCheck", 1);
            if (entity.func_184592_cb().func_77973_b() instanceof ItemTippedArrow) {
                tag.func_74768_a("NoArrowSwitch", 1);
                return;
            }
            if (entity.field_70170_p.field_73012_v.nextFloat() <= ForgeConfigHandler.server.dregoraTippedArrowReplacementChance) {
                List<PotionType> typeList = ForgeConfigHandler.getDregoraArrowAllowedPotionTypes();
                if (typeList.isEmpty()) {
                    return;
                }
                tag.func_74768_a("ArrowEntity", 1);
                ItemStack arrow = PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_185167_i, 1), (PotionType)typeList.get(entity.field_70170_p.field_73012_v.nextInt(typeList.size())));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, arrow);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Biome biome;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.field_70170_p.field_72995_K || entity.field_71093_bK != 0) {
            return;
        }
        ResourceLocation entityid = EntityList.func_191301_a((Entity)entity);
        if (!playerBossReg.equals((Object)entityid)) {
            return;
        }
        if (entity.func_95999_t().contains("Shivaxi") && playerBossBiome.equals((Object)(biome = entity.field_70170_p.func_180494_b(entity.func_180425_c())).getRegistryName())) {
            IChampionship chp;
            entity.field_70170_p.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 4.0f, false);
            Entity regEnt = EntityList.func_188429_b((ResourceLocation)dragonBossReg, (World)entity.field_70170_p);
            if (!(regEnt instanceof EntityLiving)) {
                return;
            }
            EntityLiving toSpawn = (EntityLiving)regEnt;
            NBTTagCompound comp = toSpawn.func_189511_e(new NBTTagCompound());
            comp.func_74778_a("DeathLootTable", "dregora:entities/playerbosses/abyssal_tower_shivaxi");
            comp.func_74757_a("parasitedespawn", false);
            toSpawn.func_70037_a(comp);
            toSpawn.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (ChampionHelper.isValidChampion((Entity)toSpawn) && (chp = CapabilityChampionship.getChampionship((EntityLiving)toSpawn)) != null && chp.getRank() == null) {
                Rank rank = RankManager.getRankForTier((int)1);
                chp.setRank(rank);
                Set affixes = ChampionHelper.generateAffixes((Rank)rank, (EntityLiving)toSpawn, (String[])new String[0]);
                chp.setAffixes(affixes);
                chp.setName("\u00c2\u00a74\u00e2\u02dc\u00a2 \u00c2\u00a75\u00c2\u00a7lBlighted Shivaxi\u00c2\u00a7r \u00c2\u00a74\u00e2\u02dc\u00a2");
                chp.getRank().applyGrowth((EntityLivingBase)toSpawn);
                for (String s : chp.getAffixes()) {
                    AffixBase affix = AffixRegistry.getAffix((String)s);
                    if (affix == null) continue;
                    affix.onInitialSpawn(toSpawn, chp);
                }
            }
            toSpawn.func_96094_a("\u00c2\u00a74\u00e2\u02dc\u00a2 \u00c2\u00a75\u00c2\u00a7lBlighted Shivaxi\u00c2\u00a7r \u00c2\u00a74\u00e2\u02dc\u00a2");
            toSpawn.func_110163_bv();
            toSpawn.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("LoweredHealth", (double)ForgeConfigHandler.server.dregoraScriptDragonHealth, 1));
            entity.field_70170_p.func_72838_d((Entity)toSpawn);
        }
    }
}

