/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.jsoup.parser;

import mods.thecomputerizer.shadow.org.jsoup.internal.StringUtil;
import org.jspecify.annotations.Nullable;

class TokenData {
    private @Nullable String value;
    private @Nullable StringBuilder builder;

    TokenData() {
    }

    void set(String str) {
        this.reset();
        this.value = str;
    }

    void append(String str) {
        if (this.builder != null) {
            this.builder.append(str);
        } else if (this.value != null) {
            this.flipToBuilder();
            this.builder.append(str);
        } else {
            this.value = str;
        }
    }

    void append(char c) {
        if (this.builder != null) {
            this.builder.append(c);
        } else if (this.value != null) {
            this.flipToBuilder();
            this.builder.append(c);
        } else {
            this.value = String.valueOf(c);
        }
    }

    void appendCodePoint(int codepoint) {
        if (this.builder != null) {
            this.builder.appendCodePoint(codepoint);
        } else if (this.value != null) {
            this.flipToBuilder();
            this.builder.appendCodePoint(codepoint);
        } else {
            this.value = String.valueOf(Character.toChars(codepoint));
        }
    }

    private void flipToBuilder() {
        this.builder = StringUtil.borrowBuilder();
        this.builder.append(this.value);
        this.value = null;
    }

    boolean hasData() {
        return this.builder != null || this.value != null;
    }

    void reset() {
        if (this.builder != null) {
            StringUtil.releaseBuilderVoid(this.builder);
            this.builder = null;
        }
        this.value = null;
    }

    String value() {
        if (this.builder != null) {
            this.value = this.builder.toString();
            StringUtil.releaseBuilder(this.builder);
            this.builder = null;
            return this.value;
        }
        return this.value != null ? this.value : "";
    }

    public String toString() {
        if (this.builder != null) {
            return this.builder.toString();
        }
        return this.value != null ? this.value : "";
    }
}

