/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.apache.http.impl.conn;

import java.net.InetAddress;
import mods.thecomputerizer.shadow.org.apache.http.HttpException;
import mods.thecomputerizer.shadow.org.apache.http.HttpHost;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequest;
import mods.thecomputerizer.shadow.org.apache.http.ProtocolException;
import mods.thecomputerizer.shadow.org.apache.http.annotation.Contract;
import mods.thecomputerizer.shadow.org.apache.http.annotation.ThreadingBehavior;
import mods.thecomputerizer.shadow.org.apache.http.client.config.RequestConfig;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.apache.http.conn.SchemePortResolver;
import mods.thecomputerizer.shadow.org.apache.http.conn.UnsupportedSchemeException;
import mods.thecomputerizer.shadow.org.apache.http.conn.routing.HttpRoute;
import mods.thecomputerizer.shadow.org.apache.http.conn.routing.HttpRoutePlanner;
import mods.thecomputerizer.shadow.org.apache.http.impl.conn.DefaultSchemePortResolver;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpContext;
import mods.thecomputerizer.shadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        return proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

