/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mods.thecomputerizer.shadow.org.apache.http.HttpException;
import mods.thecomputerizer.shadow.org.apache.http.HttpHost;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequest;
import mods.thecomputerizer.shadow.org.apache.http.annotation.Contract;
import mods.thecomputerizer.shadow.org.apache.http.annotation.ThreadingBehavior;
import mods.thecomputerizer.shadow.org.apache.http.client.ClientProtocolException;
import mods.thecomputerizer.shadow.org.apache.http.client.config.RequestConfig;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.Configurable;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpExecutionAware;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpRequestWrapper;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.apache.http.conn.ClientConnectionManager;
import mods.thecomputerizer.shadow.org.apache.http.conn.ClientConnectionRequest;
import mods.thecomputerizer.shadow.org.apache.http.conn.HttpClientConnectionManager;
import mods.thecomputerizer.shadow.org.apache.http.conn.ManagedClientConnection;
import mods.thecomputerizer.shadow.org.apache.http.conn.routing.HttpRoute;
import mods.thecomputerizer.shadow.org.apache.http.conn.scheme.SchemeRegistry;
import mods.thecomputerizer.shadow.org.apache.http.impl.DefaultConnectionReuseStrategy;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.CloseableHttpClient;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import mods.thecomputerizer.shadow.org.apache.http.impl.execchain.MinimalClientExec;
import mods.thecomputerizer.shadow.org.apache.http.params.BasicHttpParams;
import mods.thecomputerizer.shadow.org.apache.http.params.HttpParams;
import mods.thecomputerizer.shadow.org.apache.http.protocol.BasicHttpContext;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpContext;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpRequestExecutor;
import mods.thecomputerizer.shadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

