/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.me.devoxin.lavadspx;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;
import mods.thecomputerizer.shadow.me.devoxin.lavadspx.EchoConverter;

public class EchoFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private final EchoConverter[] converters;

    public EchoFilter(FloatPcmAudioFilter downstream, int sampleRate, int channelCount) {
        this(downstream, sampleRate, channelCount, 0.0f);
    }

    public EchoFilter(FloatPcmAudioFilter downstream, int sampleRate, int channelCount, float echoLength) {
        this(downstream, sampleRate, channelCount, echoLength, 0.0f);
    }

    public EchoFilter(FloatPcmAudioFilter downstream, int sampleRate, int channelCount, float echoLength, float decay) {
        this.downstream = downstream;
        this.converters = new EchoConverter[channelCount];
        for (int c = 0; c < channelCount; ++c) {
            this.converters[c] = new EchoConverter(sampleRate, echoLength, decay);
        }
    }

    public void setEchoLength(float seconds) {
        for (EchoConverter converter : this.converters) {
            converter.setEchoLength(seconds);
        }
    }

    public void setEchoDecay(float decay) {
        for (EchoConverter converter : this.converters) {
            converter.setEchoDecay(decay);
        }
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        for (int c = 0; c < input.length; ++c) {
            this.converters[c].process(input[c], offset, length);
        }
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

