/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.me.devoxin.lavadspx;

import mods.thecomputerizer.shadow.me.devoxin.lavadspx.utils.Converter;

public class EchoConverter
implements Converter {
    private final int sampleRate;
    private float echoLength;
    private float decay;
    private float[] echoBuffer;
    private int position;

    public EchoConverter(int sampleRate) {
        this(sampleRate, 0.0f);
    }

    public EchoConverter(int sampleRate, float echoLength) {
        this(sampleRate, echoLength, 0.0f);
    }

    public EchoConverter(int sampleRate, float echoLength, float decay) {
        this.sampleRate = sampleRate;
        this.echoLength = echoLength;
        this.decay = decay;
        this.applyNewEchoBuffer();
    }

    public void setEchoLength(float seconds) {
        this.echoLength = seconds;
    }

    public void setEchoDecay(float decay) {
        this.decay = decay;
    }

    private void applyNewEchoBuffer() {
        if (this.echoLength == -1.0f) {
            return;
        }
        float[] newEchoBuffer = new float[(int)((float)this.sampleRate * this.echoLength)];
        if (this.echoBuffer != null) {
            for (int i = 0; i < newEchoBuffer.length; ++i) {
                this.checkPositionAndRewind();
                newEchoBuffer[i] = this.echoBuffer[this.position++];
            }
        }
        this.echoBuffer = newEchoBuffer;
        this.echoLength = -1.0f;
    }

    @Override
    public void process(float[] input, int offset, int length) {
        if (this.echoBuffer != null) {
            for (int i = offset; i < offset + length; ++i) {
                this.checkPositionAndRewind();
                float current = input[i] + this.echoBuffer[this.position] * this.decay;
                this.echoBuffer[this.position++] = input[i] = current;
            }
        }
        this.applyNewEchoBuffer();
    }

    private void checkPositionAndRewind() {
        if (this.position >= this.echoBuffer.length) {
            this.position = 0;
        }
    }
}

