/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.ibxm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mods.thecomputerizer.shadow.ibxm.IBXM;
import mods.thecomputerizer.shadow.ibxm.Instrument;
import mods.thecomputerizer.shadow.ibxm.Module;
import mods.thecomputerizer.shadow.ibxm.PatternDisplay;
import mods.thecomputerizer.shadow.ibxm.WavInputStream;

public class IBXMPlayer
extends JFrame {
    private static final String[] EXTENSIONS = new String[]{"mod", "ft", "s3m", "xm"};
    private static final int SAMPLE_RATE = 48000;
    private static final int FADE_SECONDS = 16;
    private static final int REVERB_MILLIS = 50;
    private JLabel songLabel;
    private JLabel timeLabel;
    private JSlider seekSlider;
    private JButton playButton;
    private JList<String> instrumentList;
    private javax.swing.Timer updateTimer;
    private JFileChooser loadFileChooser;
    private JFileChooser saveFileChooser;
    private JCheckBox fadeOutCheckBox;
    private JTextField fadeOutTextField;
    private JScrollBar patternScrollBar;
    private Module module;
    private IBXM ibxm;
    private volatile boolean playing;
    private int[] reverbBuf;
    private int interpolation;
    private int reverbIdx;
    private int reverbLen;
    private int sliderPos;
    private int samplePos;
    private int duration;
    private int row;
    private int seqPos;
    private Timer displayTimer;
    private Thread playThread;
    private PatternDisplay patternDisplay;

    public IBXMPlayer() {
        super("IBXM a75 (c)2021 mumart@gmail.com");
        URL icon = IBXMPlayer.class.getResource("mods.thecomputerizer.shadow.ibxm.png");
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(icon));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout(5, 5));
        this.songLabel = new JLabel("No song loaded.", 0);
        controlPanel.add((Component)this.songLabel, "North");
        this.timeLabel = new JLabel("0:00");
        controlPanel.add((Component)this.timeLabel, "West");
        this.playButton = new JButton("Play");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IBXMPlayer.this.playing) {
                    IBXMPlayer.this.stop();
                } else {
                    IBXMPlayer.this.play();
                }
            }
        });
        controlPanel.add((Component)this.playButton, "East");
        this.seekSlider = new JSlider(0, 0, 0, 0);
        this.seekSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!IBXMPlayer.this.seekSlider.getValueIsAdjusting() && IBXMPlayer.this.ibxm != null && !IBXMPlayer.this.playing) {
                    if (IBXMPlayer.this.seekSlider.getValue() != IBXMPlayer.this.sliderPos) {
                        IBXMPlayer.this.seek(IBXMPlayer.this.seekSlider.getValue());
                    }
                    IBXMPlayer.this.sliderPos = IBXMPlayer.this.samplePos;
                    IBXMPlayer.this.seekSlider.setValue(IBXMPlayer.this.sliderPos);
                    IBXMPlayer.this.updateTimeLabel();
                    IBXMPlayer.this.patternDisplay.display(IBXMPlayer.this.module, ((IBXMPlayer)IBXMPlayer.this).module.sequence[IBXMPlayer.this.ibxm.getSequencePos()], IBXMPlayer.this.ibxm.getRow());
                }
            }
        });
        controlPanel.add((Component)this.seekSlider, "Center");
        this.instrumentList = new JList();
        this.instrumentList.setFont(new Font("Monospaced", 1, 12));
        this.instrumentList.setOpaque(false);
        JScrollPane instrumentPane = new JScrollPane(this.instrumentList);
        instrumentPane.setBorder(BorderFactory.createTitledBorder("Instruments"));
        JTree fileTree = new JTree(new TreeModel(){

            @Override
            public void addTreeModelListener(TreeModelListener l) {
            }

            @Override
            public Object getChild(Object parent, int index) {
                return ((Node)parent).getChildren()[index];
            }

            @Override
            public int getChildCount(Object parent) {
                return ((Node)parent).getChildren().length;
            }

            @Override
            public int getIndexOfChild(Object parent, Object child) {
                Node[] children = ((Node)parent).getChildren();
                for (int idx = 0; idx < children.length; ++idx) {
                    if (!children[idx].equals(child)) continue;
                    return idx;
                }
                return -1;
            }

            @Override
            public Object getRoot() {
                return new Node(null);
            }

            @Override
            public boolean isLeaf(Object node) {
                return !((Node)node).hasChildren();
            }

            @Override
            public void removeTreeModelListener(TreeModelListener l) {
            }

            @Override
            public void valueForPathChanged(TreePath path, Object newValue) {
            }
        });
        fileTree.setVisibleRowCount(10);
        fileTree.setFont(new Font("Monospaced", 0, 12));
        fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                File file = ((Node)treeSelectionEvent.getPath().getLastPathComponent()).getFile();
                if (!file.isDirectory()) {
                    try {
                        IBXMPlayer.this.loadModule(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        JScrollPane fileTreePane = new JScrollPane(fileTree);
        fileTreePane.setBorder(BorderFactory.createTitledBorder("Module Path"));
        this.patternDisplay = new PatternDisplay();
        this.patternDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (IBXMPlayer.this.ibxm != null) {
                    int channel = IBXMPlayer.this.patternDisplay.getChannel(e.getX());
                    if (channel < 0 || e.getButton() > 1) {
                        IBXMPlayer.this.patternDisplay.setMuted(-1, false);
                        IBXMPlayer.this.ibxm.setMuted(-1, false);
                    } else if (IBXMPlayer.this.patternDisplay.isMuted(channel)) {
                        IBXMPlayer.this.patternDisplay.setMuted(channel, false);
                        IBXMPlayer.this.ibxm.setMuted(channel, false);
                    } else {
                        IBXMPlayer.this.patternDisplay.setMuted(-1, true);
                        IBXMPlayer.this.ibxm.setMuted(-1, true);
                        IBXMPlayer.this.patternDisplay.setMuted(channel, false);
                        IBXMPlayer.this.ibxm.setMuted(channel, false);
                    }
                    if (!IBXMPlayer.this.playing) {
                        IBXMPlayer.this.patternDisplay.display(IBXMPlayer.this.module, ((IBXMPlayer)IBXMPlayer.this).module.sequence[IBXMPlayer.this.ibxm.getSequencePos()], IBXMPlayer.this.ibxm.getRow());
                    }
                }
            }
        });
        this.patternScrollBar = new JScrollBar(0, 0, 0, 0, 0);
        this.patternScrollBar.setUnitIncrement(88);
        this.patternScrollBar.setBlockIncrement(352);
        this.patternScrollBar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IBXMPlayer.this.patternDisplay.setPan(IBXMPlayer.this.patternScrollBar.getValue());
            }
        });
        final JPanel patternPanel = new JPanel();
        patternPanel.setLayout(new BorderLayout());
        patternPanel.add((Component)this.patternDisplay, "Center");
        patternPanel.add((Component)this.patternScrollBar, "South");
        patternPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                IBXMPlayer.this.updatePatternScrollBar();
            }
        });
        DropTarget dropTarget = new DropTarget(this, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    DataFlavor dataFlavor = DataFlavor.javaFileListFlavor;
                    List fileList = (List)transferable.getTransferData(dataFlavor);
                    if (fileList != null && fileList.size() > 0) {
                        IBXMPlayer.this.loadModule((File)fileList.get(0));
                    }
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                }
            }
        });
        this.updateTimer = new javax.swing.Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!IBXMPlayer.this.seekSlider.getValueIsAdjusting()) {
                    if (IBXMPlayer.this.seekSlider.getValue() != IBXMPlayer.this.sliderPos) {
                        IBXMPlayer.this.seek(IBXMPlayer.this.seekSlider.getValue());
                    }
                    IBXMPlayer.this.sliderPos = IBXMPlayer.this.samplePos;
                    if (IBXMPlayer.this.sliderPos > IBXMPlayer.this.duration) {
                        IBXMPlayer.this.sliderPos = IBXMPlayer.this.duration;
                    }
                    IBXMPlayer.this.seekSlider.setValue(IBXMPlayer.this.sliderPos);
                }
                IBXMPlayer.this.updateTimeLabel();
            }
        });
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        this.loadFileChooser = new JFileChooser();
        this.loadFileChooser.setFileFilter(new FileNameExtensionFilter("Module files", "mod", "ft", "s3m", "xm"));
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.setFileFilter(new FileNameExtensionFilter("Wave files", "wav"));
        JPanel saveAccessory = new JPanel();
        this.fadeOutTextField = new JTextField("0", 4);
        this.fadeOutTextField.setEnabled(false);
        this.fadeOutTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        this.fadeOutTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    Integer.parseInt(IBXMPlayer.this.fadeOutTextField.getText());
                }
                catch (Exception exception) {
                    IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                }
            }
        });
        this.fadeOutCheckBox = new JCheckBox("Fade out after");
        this.fadeOutCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                IBXMPlayer.this.fadeOutTextField.setEnabled(IBXMPlayer.this.fadeOutCheckBox.isSelected());
            }
        });
        saveAccessory.add(this.fadeOutCheckBox);
        saveAccessory.add(this.fadeOutTextField);
        saveAccessory.add(new JLabel("seconds."));
        this.saveFileChooser.setAccessory(saveAccessory);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem loadMenuItem = new JMenuItem("Load module.");
        loadMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int result = IBXMPlayer.this.loadFileChooser.showOpenDialog(IBXMPlayer.this);
                if (result == 0) {
                    try {
                        IBXMPlayer.this.loadModule(IBXMPlayer.this.loadFileChooser.getSelectedFile());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                    }
                }
            }
        });
        fileMenu.add(loadMenuItem);
        JMenuItem saveWavMenuItem = new JMenuItem("Save module as wave file.");
        saveWavMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IBXMPlayer.this.module != null) {
                    IBXMPlayer.this.fadeOutCheckBox.setSelected(false);
                    IBXMPlayer.this.fadeOutTextField.setText(String.valueOf(IBXMPlayer.this.duration / 48000));
                    IBXMPlayer.this.saveFileChooser.setSelectedFile(new File(((IBXMPlayer)IBXMPlayer.this).module.songName.trim() + ".wav"));
                    int result = IBXMPlayer.this.saveFileChooser.showSaveDialog(IBXMPlayer.this);
                    if (result == 0) {
                        try {
                            boolean fade = IBXMPlayer.this.fadeOutCheckBox.isSelected();
                            int time = IBXMPlayer.this.duration;
                            if (fade) {
                                try {
                                    time = (Integer.parseInt(IBXMPlayer.this.fadeOutTextField.getText()) + 16) * 48000;
                                }
                                catch (Exception e) {
                                    fade = false;
                                }
                            }
                            IBXMPlayer.this.saveWav(IBXMPlayer.this.saveFileChooser.getSelectedFile(), time, fade ? 16 : 0);
                            JOptionPane.showMessageDialog(IBXMPlayer.this, "Module saved successfully.", "Success", 1);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                        }
                    }
                }
            }
        });
        fileMenu.add(saveWavMenuItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.stop();
                IBXMPlayer.this.dispose();
            }
        });
        fileMenu.add(exitMenuItem);
        menuBar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        final JCheckBoxMenuItem patternMenuItem = new JCheckBoxMenuItem("Pattern Display", true);
        patternMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                patternPanel.setVisible(patternMenuItem.isSelected());
            }
        });
        optionsMenu.add(patternMenuItem);
        optionsMenu.addSeparator();
        ButtonGroup interpolationGroup = new ButtonGroup();
        JRadioButtonMenuItem noneMenuItem = new JRadioButtonMenuItem("No interpolation");
        noneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(0);
            }
        });
        interpolationGroup.add(noneMenuItem);
        optionsMenu.add(noneMenuItem);
        JRadioButtonMenuItem lineMenuItem = new JRadioButtonMenuItem("Linear interpolation");
        lineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(1);
            }
        });
        interpolationGroup.add(lineMenuItem);
        interpolationGroup.setSelected(lineMenuItem.getModel(), true);
        this.setInterpolation(1);
        optionsMenu.add(lineMenuItem);
        JRadioButtonMenuItem sincMenuItem = new JRadioButtonMenuItem("Sinc interpolation");
        sincMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setInterpolation(2);
            }
        });
        interpolationGroup.add(sincMenuItem);
        optionsMenu.add(sincMenuItem);
        optionsMenu.addSeparator();
        final JCheckBoxMenuItem reverbMenuItem = new JCheckBoxMenuItem("Reverb");
        reverbMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IBXMPlayer.this.setReverb(reverbMenuItem.isSelected() ? 50 : 0);
            }
        });
        optionsMenu.add(reverbMenuItem);
        menuBar.add(optionsMenu);
        this.setJMenuBar(menuBar);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setLayout(new BorderLayout(10, 10));
        mainPanel.add((Component)controlPanel, "North");
        mainPanel.add((Component)fileTreePane, "Center");
        mainPanel.add((Component)instrumentPane, "East");
        mainPanel.add((Component)patternPanel, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModule(File modFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(modFile);){
            Module module = new Module(inputStream);
            IBXM ibxm = new IBXM(module, 48000);
            ibxm.setInterpolation(this.interpolation);
            this.duration = ibxm.calculateSongDuration();
            IBXMPlayer iBXMPlayer = this;
            synchronized (iBXMPlayer) {
                this.sliderPos = 0;
                this.samplePos = 0;
                this.seekSlider.setMinimum(0);
                this.seekSlider.setMaximum(this.duration);
                this.seekSlider.setValue(0);
                this.patternDisplay.setPan(0);
                this.patternDisplay.setMuted(-1, false);
                this.patternDisplay.display(module, 0, 0);
                this.updatePatternScrollBar();
                String songName = module.songName.trim();
                this.songLabel.setText(songName.length() > 0 ? songName : modFile.getName());
                Vector<String> vector = new Vector<String>();
                Instrument[] instruments = module.instruments;
                int len = instruments.length;
                for (int idx = 0; idx < len; ++idx) {
                    String name = instruments[idx].name;
                    if (name.trim().length() <= 0) continue;
                    vector.add(String.format("%03d: %s", idx, name));
                }
                this.instrumentList.setListData(vector);
                this.module = module;
                this.ibxm = ibxm;
            }
        }
    }

    private void updateTimeLabel() {
        int secs = this.sliderPos / 48000;
        int mins = secs / 60;
        this.timeLabel.setText(mins + ((secs %= 60) < 10 ? ":0" : ":") + secs);
    }

    private void updatePatternScrollBar() {
        this.patternScrollBar.setMaximum(this.patternDisplay.getPreferredSize().width);
        this.patternScrollBar.setVisibleAmount(this.patternDisplay.getWidth());
    }

    private void updateDisplay(int delay) {
        if (this.patternDisplay.isShowing()) {
            int p = this.ibxm.getSequencePos();
            int r = this.ibxm.getRow();
            if (p != this.seqPos || r != this.row) {
                this.row = r;
                this.seqPos = p;
                this.displayTimer.schedule(new TimerTask(){
                    private Module module;
                    private int pat;
                    private int row;

                    public TimerTask init(Module module, int pat, int row) {
                        this.module = module;
                        this.pat = pat;
                        this.row = row;
                        return this;
                    }

                    @Override
                    public void run() {
                        IBXMPlayer.this.patternDisplay.display(this.module, this.pat, this.row);
                        Toolkit.getDefaultToolkit().sync();
                    }
                }.init(this.module, this.module.sequence[this.seqPos], this.row), delay > 0 ? (long)delay : 0L);
            }
        }
    }

    private synchronized void play() {
        if (this.ibxm != null) {
            this.playing = true;
            this.row = -1;
            this.seqPos = -1;
            this.displayTimer = new Timer();
            this.playThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] mixBuf = new int[IBXMPlayer.this.ibxm.getMixBufferLength()];
                    byte[] outBuf = new byte[mixBuf.length * 2];
                    AudioFormat audioFormat = null;
                    Line audioLine = null;
                    try {
                        audioFormat = new AudioFormat(48000.0f, 16, 2, true, true);
                        audioLine = AudioSystem.getSourceDataLine(audioFormat);
                        audioLine.open();
                        audioLine.start();
                        while (IBXMPlayer.this.playing) {
                            IBXMPlayer.this.updateDisplay((audioLine.getBufferSize() - audioLine.available()) * 250 / 48000);
                            int count = IBXMPlayer.this.getAudio(mixBuf);
                            if (IBXMPlayer.this.reverbLen > 0) {
                                IBXMPlayer.this.reverb(mixBuf, count);
                            }
                            int outIdx = 0;
                            int mixEnd = count * 2;
                            for (int mixIdx = 0; mixIdx < mixEnd; ++mixIdx) {
                                int ampl = mixBuf[mixIdx];
                                if (ampl > Short.MAX_VALUE) {
                                    ampl = Short.MAX_VALUE;
                                }
                                if (ampl < Short.MIN_VALUE) {
                                    ampl = Short.MIN_VALUE;
                                }
                                outBuf[outIdx++] = (byte)(ampl >> 8);
                                outBuf[outIdx++] = (byte)ampl;
                            }
                            audioLine.write(outBuf, 0, outIdx);
                        }
                        audioLine.drain();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(IBXMPlayer.this, e.getMessage(), "Error", 0);
                    }
                    finally {
                        IBXMPlayer.this.displayTimer.cancel();
                        if (audioLine != null && audioLine.isOpen()) {
                            audioLine.close();
                        }
                    }
                }
            });
            this.playThread.start();
            this.updateTimer.start();
            this.playButton.setText("Stop");
        }
    }

    private synchronized void stop() {
        this.playing = false;
        try {
            if (this.playThread != null) {
                this.playThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.updateTimer.stop();
        this.playButton.setText("Play");
    }

    private synchronized void seek(int pos) {
        this.samplePos = this.ibxm.seek(pos);
    }

    private synchronized void setInterpolation(int interpolation) {
        this.interpolation = interpolation;
        if (this.ibxm != null) {
            this.ibxm.setInterpolation(interpolation);
        }
    }

    private synchronized void setReverb(int millis) {
        this.reverbLen = 48000 * millis >> 9 & 0xFFFFFFFE;
        this.reverbBuf = new int[this.reverbLen];
        this.reverbIdx = 0;
    }

    private synchronized int getAudio(int[] mixBuf) {
        int count = this.ibxm.getAudio(mixBuf);
        this.samplePos += count;
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveWav(File wavFile, int time, int fade) throws IOException {
        this.stop();
        this.seek(0);
        WavInputStream wavInputStream = new WavInputStream(this.ibxm, time, fade);
        FileOutputStream fileOutputStream = null;
        try {
            int count;
            fileOutputStream = new FileOutputStream(wavFile);
            byte[] buf = new byte[this.ibxm.getMixBufferLength() * 2];
            for (int remain = wavInputStream.getBytesRemaining(); remain > 0; remain -= count) {
                count = remain > buf.length ? buf.length : remain;
                count = wavInputStream.read(buf, 0, count);
                fileOutputStream.write(buf, 0, count);
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            this.seek(0);
        }
    }

    private void reverb(int[] mixBuf, int count) {
        int mixEnd = count << 1;
        for (int mixIdx = 0; mixIdx < mixEnd; mixIdx += 2) {
            mixBuf[mixIdx] = mixBuf[mixIdx] * 3 + this.reverbBuf[this.reverbIdx + 1] >> 2;
            mixBuf[mixIdx + 1] = mixBuf[mixIdx + 1] * 3 + this.reverbBuf[this.reverbIdx] >> 2;
            this.reverbBuf[this.reverbIdx] = mixBuf[mixIdx];
            this.reverbBuf[this.reverbIdx + 1] = mixBuf[mixIdx + 1];
            this.reverbIdx += 2;
            if (this.reverbIdx < this.reverbLen) continue;
            this.reverbIdx = 0;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                IBXMPlayer ibxmPlayer = new IBXMPlayer();
                ibxmPlayer.setDefaultCloseOperation(3);
                ibxmPlayer.setLocationByPlatform(true);
                ibxmPlayer.setVisible(true);
            }
        });
    }

    private static class Node {
        private File file;

        public Node(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            String name = "File System                     ";
            if (this.file != null && (name = this.file.getName()).length() < 1) {
                name = this.file.toString();
            }
            return name;
        }

        public int hashCode() {
            return this.file != null ? this.file.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Node) {
                Node node = (Node)obj;
                return this.file == node.file || this.file != null && this.file.equals(node.file);
            }
            return false;
        }

        public Node[] getChildren() {
            TreeMap<String, Object> files = new TreeMap<String, Object>();
            if (this.file == null) {
                for (File root : File.listRoots()) {
                    files.put(root.getName().toLowerCase(), root);
                }
                File home = new File(System.getProperty("user.home"));
                files.put(home.getName().toLowerCase(), home);
            } else {
                for (File child : this.file.listFiles()) {
                    String filename = child.getName().toLowerCase();
                    boolean supported = false;
                    for (String extension : EXTENSIONS) {
                        supported = supported || filename.startsWith(extension) || filename.endsWith(extension);
                    }
                    if (!supported && (!child.isDirectory() || child.isHidden())) continue;
                    files.put(filename, child);
                }
            }
            Node[] nodes = new Node[files.size()];
            int idx = 0;
            for (File value : files.values()) {
                nodes[idx++] = new Node(value);
            }
            return nodes;
        }

        public boolean hasChildren() {
            return this.file == null || this.file.isDirectory();
        }
    }
}

