/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.dev.lavalink.youtube.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.Android;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.ClientConfig;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpPost;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.apache.http.entity.StringEntity;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;
import org.jetbrains.annotations.NotNull;

public class YoutubeAccessTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAccessTokenTracker.class);
    private static final String TOKEN_FETCH_CONTEXT_ATTRIBUTE = "yt-raw";
    private static final long VISITOR_ID_REFRESH_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final Object tokenLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private String visitorId;
    private long lastVisitorIdUpdate;

    public YoutubeAccessTokenTracker(@NotNull HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorId() {
        long now = System.currentTimeMillis();
        if (this.visitorId == null || now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
            Object object = this.tokenLock;
            synchronized (object) {
                if (now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
                    log.debug("YouTube visitor id was recently updated, not updating again right away.");
                    return this.visitorId;
                }
                this.lastVisitorIdUpdate = now;
                try {
                    this.visitorId = this.fetchVisitorId();
                    log.info("Updating YouTube visitor id succeeded, new one is {}, next update will be after {} seconds.", (Object)this.visitorId, (Object)TimeUnit.MILLISECONDS.toSeconds(VISITOR_ID_REFRESH_INTERVAL));
                }
                catch (Exception e) {
                    log.error("YouTube visitor id update failed.", e);
                }
            }
        }
        return this.visitorId;
    }

    public boolean isTokenFetchContext(@NotNull HttpClientContext context) {
        return context.getAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String fetchVisitorId() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            String string;
            block12: {
                httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
                ClientConfig client = Android.BASE_CONFIG.setAttributes(httpInterface);
                HttpPost visitorIdPost = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/visitor_id");
                visitorIdPost.setEntity(new StringEntity(client.toJsonString(), "UTF-8"));
                CloseableHttpResponse response = httpInterface.execute(visitorIdPost);
                try {
                    HttpClientTools.assertSuccessWithContent(response, "youtube visitor id");
                    JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
                    string = json.get("responseContext").get("visitorData").text();
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }
}

