/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.dev.lavalink.youtube.clients;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.YoutubeAudioSourceManager;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.ClientConfig;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.ClientOptions;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.clients.skeleton.StreamingNonMusicClient;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpGet;
import mods.thecomputerizer.shadow.org.apache.http.client.utils.URIBuilder;
import mods.thecomputerizer.shadow.org.apache.http.util.EntityUtils;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web
extends StreamingNonMusicClient {
    private static final Logger log = LoggerFactory.getLogger(Web.class);
    protected static Pattern CONFIG_REGEX = Pattern.compile("ytcfg\\.set\\((\\{.+})\\);");
    public static ClientConfig BASE_CONFIG = new ClientConfig().withClientName("WEB").withClientField("clientVersion", "2.20250403.01.00").withUserField("lockedSafetyMode", false);
    public static String poToken;
    protected volatile long lastConfigUpdate = -1L;
    protected ClientOptions options;

    public Web() {
        this(ClientOptions.DEFAULT);
    }

    public Web(@NotNull ClientOptions options) {
        this.options = options;
    }

    public static void setPoTokenAndVisitorData(String poToken, String visitorData) {
        Web.poToken = poToken;
        if (poToken == null || visitorData == null) {
            BASE_CONFIG.getRoot().remove("serviceIntegrityDimensions");
            BASE_CONFIG.withVisitorData(null);
            return;
        }
        Map<String, Object> sid = BASE_CONFIG.putOnceAndJoin(BASE_CONFIG.getRoot(), "serviceIntegrityDimensions");
        sid.put("poToken", poToken);
        BASE_CONFIG.withVisitorData(visitorData);
    }

    protected void fetchClientConfig(@NotNull HttpInterface httpInterface) {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com"));){
            String clientVersion;
            HttpClientTools.assertSuccessWithContent(response, "client config fetch");
            this.lastConfigUpdate = System.currentTimeMillis();
            String page = EntityUtils.toString(response.getEntity());
            Matcher m = CONFIG_REGEX.matcher(page);
            if (!m.find()) {
                log.warn("Unable to find youtube client config in base page, html: {}", (Object)page);
                return;
            }
            JsonBrowser json = JsonBrowser.parse(m.group(1));
            JsonBrowser client = json.get("INNERTUBE_CONTEXT").get("client");
            String apiKey = json.get("INNERTUBE_API_KEY").text();
            if (!apiKey.isEmpty()) {
                BASE_CONFIG.withApiKey(apiKey);
            }
            if (!client.isNull() && !(clientVersion = client.get("clientVersion").text()).isEmpty()) {
                BASE_CONFIG.withClientField("clientVersion", clientVersion);
            }
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClientConfig getBaseClientConfig(@NotNull HttpInterface httpInterface) {
        if (this.lastConfigUpdate == -1L) {
            Web web = this;
            synchronized (web) {
                if (this.lastConfigUpdate == -1L) {
                    this.fetchClientConfig(httpInterface);
                }
            }
        }
        return BASE_CONFIG.copy();
    }

    @Override
    @NotNull
    public URI transformPlaybackUri(@NotNull URI originalUri, @NotNull URI resolvedPlaybackUri) {
        if (poToken == null) {
            return resolvedPlaybackUri;
        }
        log.debug("Applying 'pot' parameter on playback URI: {}", (Object)resolvedPlaybackUri);
        URIBuilder builder = new URIBuilder(resolvedPlaybackUri);
        builder.addParameter("pot", poToken);
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            log.debug("Failed to apply 'pot' parameter.", e);
            return resolvedPlaybackUri;
        }
    }

    @Override
    @NotNull
    protected List<AudioTrack> extractSearchResults(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json) {
        return json.get("contents").get("twoColumnSearchResultsRenderer").get("primaryContents").get("sectionListRenderer").get("contents").values().stream().flatMap(item -> item.get("itemSectionRenderer").get("contents").values().stream()).map(item -> this.extractAudioTrack(item.get("videoRenderer"), source)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @NotNull
    protected JsonBrowser extractMixPlaylistData(@NotNull JsonBrowser json) {
        return json.get("contents").get("twoColumnWatchNextResults").get("playlist").get("playlist");
    }

    @Override
    protected String extractPlaylistName(@NotNull JsonBrowser json) {
        return json.get("metadata").get("playlistMetadataRenderer").get("title").text();
    }

    @Override
    @NotNull
    protected JsonBrowser extractPlaylistVideoList(@NotNull JsonBrowser json) {
        return json.get("contents").get("twoColumnBrowseResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("itemSectionRenderer").get("contents").index(0).get("playlistVideoListRenderer");
    }

    @Override
    @Nullable
    protected String extractPlaylistContinuationToken(@NotNull JsonBrowser videoList) {
        JsonBrowser contents = videoList.get("contents");
        if (!contents.isNull()) {
            videoList = contents;
        }
        return videoList.values().stream().filter(item -> !item.get("continuationItemRenderer").isNull()).findFirst().map(item -> item.get("continuationItemRenderer").get("continuationEndpoint").get("continuationCommand").get("token").text()).orElse(null);
    }

    @Override
    @NotNull
    protected JsonBrowser extractPlaylistContinuationVideos(@NotNull JsonBrowser continuationJson) {
        return continuationJson.get("onResponseReceivedActions").index(0).get("appendContinuationItemsAction").get("continuationItems");
    }

    @Override
    @NotNull
    public String getPlayerParams() {
        return WEB_PLAYER_PARAMS;
    }

    @Override
    @NotNull
    public ClientOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return BASE_CONFIG.getName();
    }
}

