/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.dev.lavalink.youtube.cipher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.YoutubeSource;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.cipher.ScriptExtractionException;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.cipher.SignatureCipher;
import mods.thecomputerizer.shadow.dev.lavalink.youtube.track.format.StreamFormat;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpGet;
import mods.thecomputerizer.shadow.org.apache.http.client.utils.URIBuilder;
import mods.thecomputerizer.shadow.org.apache.http.util.EntityUtils;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class SignatureCipherManager {
    private static final Logger log = LoggerFactory.getLogger(SignatureCipherManager.class);
    private static final String VARIABLE_PART = "[a-zA-Z_\\$][a-zA-Z_0-9\\$]*";
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(signatureTimestamp|sts):(\\d+)");
    private static final Pattern GLOBAL_VARS_PATTERN = Pattern.compile("('use\\s*strict';)?(?<code>var\\s*(?<varname>[a-zA-Z0-9_$]+)\\s*=\\s*(?<value>(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|'[^'\\\\]*(?:\\\\.[^'\\\\]*)*')\\.split\\((?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|'[^'\\\\]*(?:\\\\.[^'\\\\]*)*')\\)|\\[(?:(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|'[^'\\\\]*(?:\\\\.[^'\\\\]*)*')\\s*,?\\s*)*\\]|\"[^\"]*\"\\.split\\(\"[^\"]*\"\\)))");
    private static final Pattern ACTIONS_PATTERN = Pattern.compile("var\\s+([A-Za-z0-9_]+)\\s*=\\s*\\{\\s*[A-Za-z0-9_]+\\s*:\\s*function\\s*\\([^)]*\\)\\s*\\{[^{}]*(?:\\{[^{}]*}[^{}]*)*}\\s*,\\s*[A-Za-z0-9_]+\\s*:\\s*function\\s*\\([^)]*\\)\\s*\\{[^{}]*(?:\\{[^{}]*}[^{}]*)*}\\s*,\\s*[A-Za-z0-9_]+\\s*:\\s*function\\s*\\([^)]*\\)\\s*\\{[^{}]*(?:\\{[^{}]*}[^{}]*)*}\\s*};");
    private static final Pattern SIG_FUNCTION_PATTERN = Pattern.compile("function(?:\\s+[a-zA-Z_\\$][a-zA-Z_0-9\\$]*)?\\(([a-zA-Z_\\$][a-zA-Z_0-9\\$]*)\\)\\{[a-zA-Z_\\$][a-zA-Z_0-9\\$]*=[a-zA-Z_\\$][a-zA-Z_0-9\\$]*.*?\\(\\1,\\d+\\);return\\s*\\1.*};");
    private static final Pattern N_FUNCTION_PATTERN = Pattern.compile("function\\(\\s*([a-zA-Z_\\$][a-zA-Z_0-9\\$]*)\\s*\\)\\s*\\{var\\s*([a-zA-Z_\\$][a-zA-Z_0-9\\$]*)=\\1\\[[a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\]\\([a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\).*?catch\\(\\s*(\\w+)\\s*\\)\\s*\\{\\s*return.*?\\+\\s*\\1\\s*}\\s*return\\s*\\2\\[[a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\]\\([a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\)};", 32);
    private static final Pattern functionPatternOld = Pattern.compile("function\\(\\s*(\\w+)\\s*\\)\\s*\\{var\\s*(\\w+)=\\1\\[[a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\]\\([a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\).*?catch\\(\\s*(\\w+)\\s*\\)\\s*\\{\\s*return.*?\\+\\s*\\1\\s*}\\s*return\\s*\\2\\[[a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\]\\([a-zA-Z_\\$][a-zA-Z_0-9\\$]*\\[\\d+\\]\\)};", 32);
    private final ConcurrentMap<String, SignatureCipher> cipherCache = new ConcurrentHashMap<String, SignatureCipher>();
    private final Set<String> dumpedScriptUrls = new HashSet<String>();
    private final ScriptEngine scriptEngine = new RhinoScriptEngineFactory().getScriptEngine();
    private final Object cipherLoadLock = new Object();
    protected volatile CachedPlayerScript cachedPlayerScript;

    @NotNull
    public URI resolveFormatUrl(@NotNull HttpInterface httpInterface, @NotNull String playerScript, @NotNull StreamFormat format) throws IOException {
        String signature = format.getSignature();
        String nParameter = format.getNParameter();
        URI initialUrl = format.getUrl();
        URIBuilder uri = new URIBuilder(initialUrl);
        SignatureCipher cipher = this.getCipherScript(httpInterface, playerScript);
        if (!DataFormatTools.isNullOrEmpty(signature)) {
            try {
                uri.setParameter(format.getSignatureKey(), cipher.apply(signature, this.scriptEngine));
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.dumpProblematicScript(((SignatureCipher)this.cipherCache.get((Object)playerScript)).rawScript, playerScript, "Can't transform s parameter " + signature);
            }
        }
        if (!DataFormatTools.isNullOrEmpty(nParameter)) {
            try {
                String transformed = cipher.transform(nParameter, this.scriptEngine);
                String logMessage = null;
                if (transformed == null) {
                    logMessage = "Transformed n parameter is null, n function possibly faulty";
                } else if (nParameter.equals(transformed)) {
                    logMessage = "Transformed n parameter is the same as input, n function possibly short-circuited";
                } else if (transformed.startsWith("enhanced_except_") || transformed.endsWith("_w8_" + nParameter)) {
                    logMessage = "N function did not complete due to exception";
                }
                if (logMessage != null) {
                    log.warn("{} (in: {}, out: {}, player script: {}, source version: {})", logMessage, nParameter, transformed, playerScript, YoutubeSource.VERSION);
                }
                uri.setParameter("n", transformed);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.dumpProblematicScript(((SignatureCipher)this.cipherCache.get((Object)playerScript)).rawScript, playerScript, "Can't transform n parameter " + nParameter + " with " + cipher.nFunction + " n function");
            }
        }
        try {
            return uri.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private CachedPlayerScript getPlayerScript(@NotNull HttpInterface httpInterface) {
        Object object = this.cipherLoadLock;
        synchronized (object) {
            CachedPlayerScript cachedPlayerScript;
            block12: {
                CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/embed/"));
                try {
                    HttpClientTools.assertSuccessWithContent(response, "fetch player script (embed)");
                    String responseText = EntityUtils.toString(response.getEntity());
                    String scriptUrl = DataFormatTools.extractBetween(responseText, "\"jsUrl\":\"", "\"");
                    if (scriptUrl == null) {
                        throw ExceptionTools.throwWithDebugInfo(log, null, "no jsUrl found", "html", responseText);
                    }
                    cachedPlayerScript = this.cachedPlayerScript = new CachedPlayerScript(scriptUrl);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionTools.toRuntimeException(e);
                    }
                }
                response.close();
            }
            return cachedPlayerScript;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPlayerScript getCachedPlayerScript(@NotNull HttpInterface httpInterface) {
        if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                if (this.cachedPlayerScript == null || System.currentTimeMillis() >= this.cachedPlayerScript.expireTimestampMs) {
                    return this.getPlayerScript(httpInterface);
                }
            }
        }
        return this.cachedPlayerScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureCipher getCipherScript(@NotNull HttpInterface httpInterface, @NotNull String cipherScriptUrl) throws IOException {
        SignatureCipher cipherKey = (SignatureCipher)this.cipherCache.get(cipherScriptUrl);
        if (cipherKey == null) {
            Object object = this.cipherLoadLock;
            synchronized (object) {
                log.debug("Parsing player script {}", (Object)cipherScriptUrl);
                try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(SignatureCipherManager.parseTokenScriptUrl(cipherScriptUrl)));){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                        throw new IOException("Received non-success response code " + statusCode + " from script url " + cipherScriptUrl + " ( " + SignatureCipherManager.parseTokenScriptUrl(cipherScriptUrl) + " )");
                    }
                    cipherKey = this.extractFromScript(EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8), cipherScriptUrl);
                    this.cipherCache.put(cipherScriptUrl, cipherKey);
                }
            }
        }
        return cipherKey;
    }

    private List<String> getQuotedFunctions(String ... functionNames) {
        return Stream.of(functionNames).filter(Objects::nonNull).map(Pattern::quote).collect(Collectors.toList());
    }

    private void dumpProblematicScript(@NotNull String script, @NotNull String sourceUrl, @NotNull String issue) {
        if (!this.dumpedScriptUrls.add(sourceUrl)) {
            return;
        }
        try {
            Path path = Files.createTempFile("lavaplayer-yt-player-script", ".js", new FileAttribute[0]);
            Files.write(path, script.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.error("Problematic YouTube player script {} detected (issue detected with script: {}). Dumped to {} (Source version: {})", sourceUrl, issue, path.toAbsolutePath(), YoutubeSource.VERSION);
        }
        catch (Exception e) {
            log.error("Failed to dump problematic YouTube player script {} (issue detected with script: {})", (Object)sourceUrl, (Object)issue);
        }
    }

    private SignatureCipher extractFromScript(@NotNull String script, @NotNull String sourceUrl) {
        Matcher nFunctionMatcher;
        Matcher sigFunctionMatcher;
        Matcher sigActionsMatcher;
        Matcher globalVarsMatcher;
        Matcher scriptTimestamp = TIMESTAMP_PATTERN.matcher(script);
        if (!scriptTimestamp.find()) {
            this.scriptExtractionFailed(script, sourceUrl, ScriptExtractionException.ExtractionFailureType.TIMESTAMP_NOT_FOUND);
        }
        if (!(globalVarsMatcher = GLOBAL_VARS_PATTERN.matcher(script)).find()) {
            this.scriptExtractionFailed(script, sourceUrl, ScriptExtractionException.ExtractionFailureType.VARIABLES_NOT_FOUND);
        }
        if (!(sigActionsMatcher = ACTIONS_PATTERN.matcher(script)).find()) {
            this.scriptExtractionFailed(script, sourceUrl, ScriptExtractionException.ExtractionFailureType.SIG_ACTIONS_NOT_FOUND);
        }
        if (!(sigFunctionMatcher = SIG_FUNCTION_PATTERN.matcher(script)).find()) {
            this.scriptExtractionFailed(script, sourceUrl, ScriptExtractionException.ExtractionFailureType.DECIPHER_FUNCTION_NOT_FOUND);
        }
        if (!(nFunctionMatcher = N_FUNCTION_PATTERN.matcher(script)).find()) {
            this.scriptExtractionFailed(script, sourceUrl, ScriptExtractionException.ExtractionFailureType.N_FUNCTION_NOT_FOUND);
        }
        String timestamp = scriptTimestamp.group(2);
        String globalVars = globalVarsMatcher.group("code");
        String sigActions = sigActionsMatcher.group(0);
        String sigFunction = sigFunctionMatcher.group(0);
        String nFunction = nFunctionMatcher.group(0);
        String nfParameterName = DataFormatTools.extractBetween(nFunction, "(", ")");
        nFunction = nFunction.replaceAll("if\\s*\\(typeof\\s*[^\\s()]+\\s*===?.*?\\)return " + nfParameterName + "\\s*;?", "");
        return new SignatureCipher(timestamp, globalVars, sigActions, sigFunction, nFunction, script);
    }

    private void scriptExtractionFailed(String script, String sourceUrl, ScriptExtractionException.ExtractionFailureType failureType) {
        this.dumpProblematicScript(script, sourceUrl, "must find " + failureType.friendlyName);
        throw new ScriptExtractionException("Must find " + failureType.friendlyName + " from script: " + sourceUrl, failureType);
    }

    private static String extractDollarEscapedFirstGroup(@NotNull Pattern pattern, @NotNull String text) {
        Matcher matcher = pattern.matcher(text);
        return matcher.find() ? matcher.group(1).replace("$", "\\$") : null;
    }

    private static URI parseTokenScriptUrl(@NotNull String urlString) {
        try {
            if (urlString.startsWith("//")) {
                return new URI("https:" + urlString);
            }
            if (urlString.startsWith("/")) {
                return new URI("https://www.youtube.com" + urlString);
            }
            return new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CachedPlayerScript {
        public final String url;
        public final long expireTimestampMs;

        protected CachedPlayerScript(@NotNull String url) {
            this.url = url;
            this.expireTimestampMs = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        }
    }
}

