/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;

public abstract class AbstractAudioFrameBuffer
implements AudioFrameBuffer {
    protected final AudioDataFormat format;
    protected final Object synchronizer;
    protected volatile boolean locked;
    protected volatile boolean receivedFrames;
    protected boolean terminated;
    protected boolean terminateOnEmpty;
    protected boolean clearOnInsert;

    protected AbstractAudioFrameBuffer(AudioDataFormat format) {
        this.format = format;
        this.synchronizer = new Object();
        this.locked = false;
        this.receivedFrames = false;
        this.terminated = false;
        this.terminateOnEmpty = false;
        this.clearOnInsert = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTermination() throws InterruptedException {
        Object object = this.synchronizer;
        synchronized (object) {
            while (!this.terminated) {
                this.synchronizer.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTerminateOnEmpty() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.clearOnInsert) {
                this.clear();
                this.clearOnInsert = false;
            }
            if (!this.terminated) {
                this.terminateOnEmpty = true;
                this.signalWaiters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClearOnInsert() {
        Object object = this.synchronizer;
        synchronized (object) {
            this.clearOnInsert = true;
            this.terminateOnEmpty = false;
        }
    }

    @Override
    public boolean hasClearOnInsert() {
        return this.clearOnInsert;
    }

    @Override
    public void lockBuffer() {
        this.locked = true;
    }

    @Override
    public boolean hasReceivedFrames() {
        return this.receivedFrames;
    }

    protected abstract void signalWaiters();
}

