/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;

public class TrackMarkerTracker {
    private final List<TrackMarker> markerList = new CopyOnWriteArrayList<TrackMarker>();

    public void set(TrackMarker marker, long currentTimecode) {
        if (marker == null) {
            this.trigger(TrackMarkerHandler.MarkerState.REMOVED);
        } else {
            this.trigger(TrackMarkerHandler.MarkerState.OVERWRITTEN);
            this.add(marker, currentTimecode);
        }
    }

    public void add(TrackMarker marker, long currentTimecode) {
        if (marker != null) {
            if (currentTimecode >= marker.timecode) {
                marker.handler.handle(TrackMarkerHandler.MarkerState.LATE);
            } else {
                this.markerList.add(marker);
            }
        }
    }

    public void remove(TrackMarker marker) {
        this.trigger(marker, TrackMarkerHandler.MarkerState.REMOVED);
    }

    @Deprecated
    public TrackMarker remove() {
        if (this.markerList.isEmpty()) {
            return null;
        }
        return this.markerList.remove(0);
    }

    public List<TrackMarker> getMarkers() {
        return Collections.unmodifiableList(this.markerList);
    }

    public void clear() {
        this.markerList.clear();
    }

    public void trigger(TrackMarkerHandler.MarkerState state) {
        for (TrackMarker marker : this.markerList) {
            marker.handler.handle(state);
        }
        this.clear();
    }

    public void checkPlaybackTimecode(long timecode) {
        for (TrackMarker marker : this.markerList) {
            if (marker == null || timecode < marker.timecode) continue;
            this.trigger(marker, TrackMarkerHandler.MarkerState.REACHED);
        }
    }

    public void checkSeekTimecode(long timecode) {
        for (TrackMarker marker : this.markerList) {
            if (marker == null || timecode < marker.timecode) continue;
            this.trigger(marker, TrackMarkerHandler.MarkerState.BYPASSED);
        }
    }

    private void trigger(TrackMarker marker, TrackMarkerHandler.MarkerState state) {
        if (this.markerList.remove(marker)) {
            marker.handler.handle(state);
        }
    }
}

