/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.http;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.http.ExtendedConnectionOperator;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.TrustManagerBuilder;
import mods.thecomputerizer.shadow.org.apache.http.HttpResponseFactory;
import mods.thecomputerizer.shadow.org.apache.http.ProtocolVersion;
import mods.thecomputerizer.shadow.org.apache.http.config.MessageConstraints;
import mods.thecomputerizer.shadow.org.apache.http.config.Registry;
import mods.thecomputerizer.shadow.org.apache.http.config.RegistryBuilder;
import mods.thecomputerizer.shadow.org.apache.http.conn.HttpClientConnectionManager;
import mods.thecomputerizer.shadow.org.apache.http.conn.HttpClientConnectionOperator;
import mods.thecomputerizer.shadow.org.apache.http.conn.HttpConnectionFactory;
import mods.thecomputerizer.shadow.org.apache.http.conn.ManagedHttpClientConnection;
import mods.thecomputerizer.shadow.org.apache.http.conn.routing.HttpRoute;
import mods.thecomputerizer.shadow.org.apache.http.conn.socket.ConnectionSocketFactory;
import mods.thecomputerizer.shadow.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import mods.thecomputerizer.shadow.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import mods.thecomputerizer.shadow.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import mods.thecomputerizer.shadow.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import mods.thecomputerizer.shadow.org.apache.http.impl.DefaultHttpResponseFactory;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.CloseableHttpClient;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.HttpClientBuilder;
import mods.thecomputerizer.shadow.org.apache.http.impl.conn.DefaultHttpResponseParser;
import mods.thecomputerizer.shadow.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import mods.thecomputerizer.shadow.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import mods.thecomputerizer.shadow.org.apache.http.impl.execchain.ClientExecChain;
import mods.thecomputerizer.shadow.org.apache.http.io.SessionInputBuffer;
import mods.thecomputerizer.shadow.org.apache.http.message.BasicLineParser;
import mods.thecomputerizer.shadow.org.apache.http.message.LineParser;
import mods.thecomputerizer.shadow.org.apache.http.message.ParserCursor;
import mods.thecomputerizer.shadow.org.apache.http.ssl.SSLContexts;
import mods.thecomputerizer.shadow.org.apache.http.util.CharArrayBuffer;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class ExtendedHttpClientBuilder
extends HttpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExtendedHttpClientBuilder.class);
    private static final SSLContext defaultSslContext = ExtendedHttpClientBuilder.setupSslContext();
    private SSLContext sslContextOverride;
    private String[] sslSupportedProtocols;
    private PlainConnectionSocketFactory plainSocketFactory;
    private SSLConnectionSocketFactory sslSocketFactory;
    private ConnectionManagerFactory connectionManagerFactory = ExtendedHttpClientBuilder::createDefaultConnectionManager;

    @Override
    public synchronized CloseableHttpClient build() {
        this.setConnectionManager(this.createConnectionManager());
        CloseableHttpClient httpClient = super.build();
        this.setConnectionManager(null);
        return httpClient;
    }

    public void setSslContextOverride(SSLContext sslContextOverride) {
        this.sslContextOverride = sslContextOverride;
    }

    public void setSslSupportedProtocols(String[] protocols) {
        this.sslSupportedProtocols = protocols;
    }

    public void setPlainConnectionSocketFactory(PlainConnectionSocketFactory plainSocketFactory) {
        this.plainSocketFactory = plainSocketFactory;
    }

    public void setSslConnectionSocketFactory(SSLConnectionSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setConnectionManagerFactory(ConnectionManagerFactory factory) {
        this.connectionManagerFactory = factory;
    }

    @Override
    protected ClientExecChain decorateMainExec(ClientExecChain mainExec) {
        return mainExec;
    }

    private HttpClientConnectionManager createConnectionManager() {
        return this.connectionManagerFactory.create(new ExtendedConnectionOperator(this.createConnectionSocketFactory(), null, null), ExtendedHttpClientBuilder.createConnectionFactory());
    }

    private Registry<ConnectionSocketFactory> createConnectionSocketFactory() {
        DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
        SSLConnectionSocketFactory defaultSslSocketFactory = new SSLConnectionSocketFactory(this.sslContextOverride != null ? this.sslContextOverride : defaultSslContext, this.sslSupportedProtocols, null, (HostnameVerifier)hostnameVerifier);
        return RegistryBuilder.create().register("http", this.plainSocketFactory != null ? this.plainSocketFactory : PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(this.sslSocketFactory != null ? this.sslSocketFactory : defaultSslSocketFactory))).build();
    }

    private static ManagedHttpClientConnectionFactory createConnectionFactory() {
        return new ManagedHttpClientConnectionFactory(null, (buffer, constraints) -> new GarbageAllergicHttpResponseParser(buffer, (LineParser)IcyHttpLineParser.ICY_INSTANCE, (HttpResponseFactory)DefaultHttpResponseFactory.INSTANCE, constraints));
    }

    private static HttpClientConnectionManager createDefaultConnectionManager(HttpClientConnectionOperator operator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connectionFactory) {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(operator, connectionFactory, -1L, TimeUnit.MILLISECONDS);
        manager.setMaxTotal(3000);
        manager.setDefaultMaxPerRoute(1500);
        return manager;
    }

    private static SSLContext setupSslContext() {
        try {
            X509TrustManager trustManager = new TrustManagerBuilder().addBuiltinCertificates().addFromResourceDirectory("/mods/thecomputerizer/shadow/certificates").build();
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{trustManager}, null);
            return context;
        }
        catch (Exception e) {
            log.error("Failed to build custom SSL context, using default one.", e);
            return SSLContexts.createDefault();
        }
    }

    public static interface ConnectionManagerFactory {
        public HttpClientConnectionManager create(HttpClientConnectionOperator var1, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> var2);
    }

    private static class IcyHttpLineParser
    extends BasicLineParser {
        private static final IcyHttpLineParser ICY_INSTANCE = new IcyHttpLineParser();
        private static final ProtocolVersion ICY_PROTOCOL = new ProtocolVersion("HTTP", 1, 0);

        private IcyHttpLineParser() {
        }

        @Override
        public ProtocolVersion parseProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
            int index = cursor.getPos();
            int bound = cursor.getUpperBound();
            if (bound >= index + 4 && "ICY ".equals(buffer.substring(index, index + 4))) {
                cursor.updatePos(index + 4);
                return ICY_PROTOCOL;
            }
            return super.parseProtocolVersion(buffer, cursor);
        }

        @Override
        public boolean hasProtocolVersion(CharArrayBuffer buffer, ParserCursor cursor) {
            int index = cursor.getPos();
            int bound = cursor.getUpperBound();
            if (bound >= index + 4 && "ICY ".equals(buffer.substring(index, index + 4))) {
                return true;
            }
            return super.hasProtocolVersion(buffer, cursor);
        }
    }

    private static class GarbageAllergicHttpResponseParser
    extends DefaultHttpResponseParser {
        public GarbageAllergicHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
            super(buffer, lineParser, responseFactory, constraints);
        }

        @Override
        protected boolean reject(CharArrayBuffer line, int count) {
            if (line.length() > 4 && "ICY ".equals(line.substring(0, 4))) {
                throw new FriendlyException("ICY protocol is not supported.", FriendlyException.Severity.COMMON, null);
            }
            if (count > 10) {
                throw new FriendlyException("The server is giving us garbage.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            return false;
        }
    }
}

