/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.core.JsonFactory;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.core.JsonParser;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.core.TreeNode;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.core.type.TypeReference;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.databind.JsonNode;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.databind.ObjectMapper;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.databind.node.ArrayNode;
import mods.thecomputerizer.shadow.com.fasterxml.jackson.databind.node.ObjectNode;

public class JsonBrowser {
    public static final JsonBrowser NULL_BROWSER = new JsonBrowser(null);
    private static final ObjectMapper mapper = JsonBrowser.setupMapper();
    private final JsonNode node;

    private JsonBrowser(JsonNode node) {
        this.node = node;
    }

    public boolean isList() {
        return this.node instanceof ArrayNode;
    }

    public boolean isMap() {
        return this.node instanceof ObjectNode;
    }

    public JsonBrowser index(int index) {
        if (this.isList() && index >= 0 && index < this.node.size()) {
            return JsonBrowser.create(this.node.get(index));
        }
        return NULL_BROWSER;
    }

    public JsonBrowser get(String key) {
        if (this.isMap()) {
            return JsonBrowser.create(this.node.get(key));
        }
        return NULL_BROWSER;
    }

    public void put(String key, Object item) {
        if (this.node instanceof ObjectNode) {
            if (item instanceof JsonBrowser) {
                ((ObjectNode)this.node).set(key, ((JsonBrowser)item).node);
            } else {
                ((ObjectNode)this.node).set(key, (JsonNode)mapper.valueToTree(item));
            }
        } else {
            throw new IllegalStateException("Put only works on a map");
        }
    }

    public List<JsonBrowser> values() {
        ArrayList<JsonBrowser> values = new ArrayList<JsonBrowser>();
        if (this.node != null) {
            this.node.elements().forEachRemaining(child -> values.add(new JsonBrowser((JsonNode)child)));
        }
        return values;
    }

    public <T> T as(Class<T> klass) {
        try {
            return mapper.treeToValue((TreeNode)this.node, klass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T as(TypeReference<T> type) {
        try {
            return mapper.readValue(mapper.treeAsTokens(this.node), type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String text() {
        if (this.node != null) {
            if (this.node.isNull()) {
                return null;
            }
            if (this.node.isTextual()) {
                return this.node.textValue();
            }
            if (this.node.isIntegralNumber()) {
                return String.valueOf(this.node.longValue());
            }
            if (this.node.isNumber()) {
                return this.node.numberValue().toString();
            }
            if (this.node.isBoolean()) {
                return String.valueOf(this.node.booleanValue());
            }
            return this.node.toString();
        }
        return null;
    }

    public String textOrDefault(String defaultValue) {
        String value = this.text();
        return value != null ? value : defaultValue;
    }

    public boolean asBoolean(boolean defaultValue) {
        if (this.node != null) {
            if (this.node.isBoolean()) {
                return this.node.booleanValue();
            }
            if (this.node.isTextual()) {
                if ("true".equals(this.node.textValue())) {
                    return true;
                }
                if ("false".equals(this.node.textValue())) {
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public long asLong(long defaultValue) {
        if (this.node != null) {
            if (this.node.isNumber()) {
                return this.node.numberValue().longValue();
            }
            if (this.node.isTextual()) {
                try {
                    return Long.parseLong(this.node.textValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public int asInt(int defaultValue) {
        if (this.node != null) {
            if (this.node.isNumber()) {
                return this.node.numberValue().intValue();
            }
            if (this.node.isTextual()) {
                try {
                    return Integer.parseInt(this.node.textValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    public String safeText() {
        String text = this.text();
        return text != null ? text : "";
    }

    public String format() {
        try {
            return this.node != null ? mapper.writeValueAsString(this.node) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isNull() {
        return this.node == null || this.node.isNull();
    }

    public static JsonBrowser parse(String json) throws IOException {
        return JsonBrowser.create(mapper.readTree(json));
    }

    public static JsonBrowser parse(InputStream stream) throws IOException {
        return JsonBrowser.create(mapper.readTree(stream));
    }

    public static JsonBrowser newMap() throws IOException {
        return JsonBrowser.create(mapper.createObjectNode());
    }

    private static ObjectMapper setupMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        return new ObjectMapper(jsonFactory);
    }

    private static JsonBrowser create(JsonNode node) {
        return node != null ? new JsonBrowser(node) : NULL_BROWSER;
    }
}

