/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.youtube;

import java.io.IOException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeClientConfig;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpPost;
import mods.thecomputerizer.shadow.org.apache.http.entity.StringEntity;

public class YoutubeLyricsLoader {
    public String getLyricsForVideo(HttpInterface httpInterface, String videoId) {
        JsonBrowser watchPlaylist = this.getWatchPlaylist(httpInterface, videoId);
        JsonBrowser tabRenderer = watchPlaylist.get("contents").get("singleColumnMusicWatchNextResultsRenderer").get("tabbedRenderer").get("watchNextTabbedResultsRenderer").get("tabs").index(1).get("tabRenderer");
        if (!tabRenderer.get("unselectable").isNull()) {
            return null;
        }
        String browseId = tabRenderer.get("endpoint").get("browseEndpoint").get("browseId").text();
        if (browseId == null) {
            throw new IllegalStateException("Missing browseId for lyrics watch playlist response");
        }
        return this.getLyricsFromBrowseId(httpInterface, browseId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonBrowser getWatchPlaylist(HttpInterface httpInterface, String videoId) {
        HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/next");
        String jsonString = YoutubeClientConfig.MUSIC.copy().withRootField("videoId", videoId).withRootField("playlistId", "RDAMVM" + videoId).toJsonString();
        StringEntity payload = new StringEntity(jsonString, "UTF-8");
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "playlist response");
            HttpClientTools.assertJsonContentType(response);
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getLyricsFromBrowseId(HttpInterface httpInterface, String browseId) {
        HttpPost post = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/browse");
        String jsonString = YoutubeClientConfig.MUSIC.copy().withRootField("browseId", browseId).toJsonString();
        StringEntity payload = new StringEntity(jsonString, "UTF-8");
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "browse response");
            HttpClientTools.assertJsonContentType(response);
            JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
            String lyrics = json.get("contents").get("sectionListRenderer").get("contents").index(0).get("musicDescriptionShelfRenderer").get("description").get("runs").index(0).get("text").text();
            if (lyrics == null) {
                throw new IllegalStateException("Missing lyrics from browse response");
            }
            String string = lyrics;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

