/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.twitch;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.stream.MpegTsM3uStreamAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamSegmentUrlProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class TwitchStreamAudioTrack
extends MpegTsM3uStreamAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamAudioTrack.class);
    private final TwitchStreamAudioSourceManager sourceManager;
    private final M3uStreamSegmentUrlProvider segmentUrlProvider;

    public TwitchStreamAudioTrack(AudioTrackInfo trackInfo, TwitchStreamAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
        this.segmentUrlProvider = new TwitchStreamSegmentUrlProvider(this.getChannelName(), sourceManager);
    }

    public String getChannelName() {
        return TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(this.trackInfo.identifier);
    }

    @Override
    protected M3uStreamSegmentUrlProvider getSegmentUrlProvider() {
        return this.segmentUrlProvider;
    }

    @Override
    protected HttpInterface getHttpInterface() {
        return this.sourceManager.getHttpInterface();
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        log.debug("Starting to play Twitch channel {}.", (Object)this.getChannelName());
        super.process(localExecutor);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new TwitchStreamAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

