/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.getyarn;

import java.net.URI;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.getyarn.GetyarnAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class GetyarnAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(DelegatedAudioTrack.class);
    private final GetyarnAudioSourceManager sourceManager;

    public GetyarnAudioTrack(AudioTrackInfo trackInfo, GetyarnAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Starting getyarn.io track from URL: {}", (Object)this.trackInfo.identifier);
            try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(this.trackInfo.identifier), Long.MAX_VALUE);){
                this.processDelegate(new MpegAudioTrack(this.trackInfo, inputStream), localExecutor);
            }
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new GetyarnAudioTrack(this.trackInfo, this.sourceManager);
    }
}

