/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;

public abstract class ProbingAudioSourceManager
implements AudioSourceManager {
    private static final char PARAMETERS_SEPARATOR = '|';
    protected final MediaContainerRegistry containerRegistry;

    protected ProbingAudioSourceManager(MediaContainerRegistry containerRegistry) {
        this.containerRegistry = containerRegistry;
    }

    protected AudioItem handleLoadResult(MediaContainerDetectionResult result) {
        if (result != null) {
            if (result.isReference()) {
                return result.getReference();
            }
            if (!result.isContainerDetected()) {
                throw new FriendlyException("Unknown file format.", FriendlyException.Severity.COMMON, null);
            }
            if (!result.isSupportedFile()) {
                throw new FriendlyException(result.getUnsupportedReason(), FriendlyException.Severity.COMMON, null);
            }
            return this.createTrack(result.getTrackInfo(), result.getContainerDescriptor());
        }
        return null;
    }

    protected abstract AudioTrack createTrack(AudioTrackInfo var1, MediaContainerDescriptor var2);

    protected void encodeTrackFactory(MediaContainerDescriptor factory, DataOutput output) throws IOException {
        String probeInfo = factory.probe.getName() + (factory.parameters != null ? '|' + factory.parameters : "");
        output.writeUTF(probeInfo);
    }

    protected MediaContainerDescriptor decodeTrackFactory(DataInput input) throws IOException {
        String probeInfo = input.readUTF();
        int separatorPosition = probeInfo.indexOf(124);
        String probeName = separatorPosition < 0 ? probeInfo : probeInfo.substring(0, separatorPosition);
        String parameters = separatorPosition < 0 ? null : probeInfo.substring(separatorPosition + 1);
        MediaContainerProbe probe = this.containerRegistry.find(probeName);
        if (probe != null) {
            return new MediaContainerDescriptor(probe, parameters);
        }
        return null;
    }
}

