/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.remote.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessage;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageCodec;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.remote.message.TrackFrameDataMessage;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.ImmutableAudioFrame;

public class TrackFrameDataCodec
implements RemoteMessageCodec<TrackFrameDataMessage> {
    @Override
    public Class<TrackFrameDataMessage> getMessageClass() {
        return TrackFrameDataMessage.class;
    }

    @Override
    public int version(RemoteMessage message) {
        return 1;
    }

    @Override
    public void encode(DataOutput out, TrackFrameDataMessage message) throws IOException {
        out.writeLong(message.executorId);
        out.writeInt(message.frames.size());
        for (AudioFrame frame : message.frames) {
            out.writeLong(frame.getTimecode());
            out.writeInt(frame.getDataLength());
            out.write(frame.getData());
            out.writeInt(frame.getVolume());
        }
        out.writeBoolean(message.finished);
        out.writeLong(message.seekedPosition);
    }

    @Override
    public TrackFrameDataMessage decode(DataInput in, int version) throws IOException {
        long executorId = in.readLong();
        int frameCount = in.readInt();
        ArrayList<AudioFrame> frames = new ArrayList<AudioFrame>(frameCount);
        for (int i = 0; i < frameCount; ++i) {
            long timecode = in.readLong();
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            frames.add(new ImmutableAudioFrame(timecode, data, in.readInt(), null, AudioFrame.DEFAULT_FLAGS));
        }
        return new TrackFrameDataMessage(executorId, frames, in.readBoolean(), in.readLong());
    }
}

