/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;

public abstract class AudioEventAdapter
implements AudioEventListener {
    public void onPlayerPause(AudioPlayer player) {
    }

    public void onPlayerResume(AudioPlayer player) {
    }

    public void onTrackStart(AudioPlayer player, AudioTrack track) {
    }

    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
    }

    public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
    }

    public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs) {
    }

    public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs, StackTraceElement[] stackTrace) {
        this.onTrackStuck(player, track, thresholdMs);
    }

    @Override
    public void onEvent(AudioEvent event) {
        if (event instanceof PlayerPauseEvent) {
            this.onPlayerPause(event.player);
        } else if (event instanceof PlayerResumeEvent) {
            this.onPlayerResume(event.player);
        } else if (event instanceof TrackStartEvent) {
            this.onTrackStart(event.player, ((TrackStartEvent)event).track);
        } else if (event instanceof TrackEndEvent) {
            this.onTrackEnd(event.player, ((TrackEndEvent)event).track, ((TrackEndEvent)event).endReason);
        } else if (event instanceof TrackExceptionEvent) {
            this.onTrackException(event.player, ((TrackExceptionEvent)event).track, ((TrackExceptionEvent)event).exception);
        } else if (event instanceof TrackStuckEvent) {
            TrackStuckEvent stuck = (TrackStuckEvent)event;
            this.onTrackStuck(event.player, stuck.track, stuck.thresholdMs, stuck.stackTrace);
        }
    }
}

