/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerOptions;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.CopyOnUpdateIdentityList;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameProviderTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class DefaultAudioPlayer
implements AudioPlayer,
TrackStateListener {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    protected volatile InternalAudioTrack scheduledTrack;
    protected volatile InternalAudioTrack activeTrack;
    private volatile long lastRequestTime;
    private volatile long lastReceiveTime;
    private volatile boolean stuckEventSent;
    protected volatile InternalAudioTrack shadowTrack;
    private final AtomicBoolean paused;
    protected final DefaultAudioPlayerManager manager;
    private final CopyOnUpdateIdentityList<AudioEventListener> listeners;
    protected final Object trackSwitchLock;
    private final AudioPlayerOptions options;
    private AudioConfiguration configuration;

    public DefaultAudioPlayer(DefaultAudioPlayerManager manager) {
        this.manager = manager;
        this.activeTrack = null;
        this.paused = new AtomicBoolean();
        this.listeners = new CopyOnUpdateIdentityList();
        this.trackSwitchLock = new Object();
        this.options = new AudioPlayerOptions();
    }

    private AudioConfiguration getMainConfiguration() {
        return this.configuration == null ? this.manager.getConfiguration() : this.configuration;
    }

    @Override
    public AudioConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.manager.getConfiguration().copy();
        }
        return this.configuration;
    }

    @Override
    public AudioTrack getPlayingTrack() {
        return this.activeTrack;
    }

    @Override
    public AudioTrack getScheduledTrack() {
        return this.scheduledTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleTrack(AudioTrack track) {
        if (this.activeTrack == null && track != null) {
            return false;
        }
        boolean scheduled = false;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack newTrack;
            if (this.scheduledTrack != null) {
                this.scheduledTrack.stop();
            }
            this.scheduledTrack = newTrack = (InternalAudioTrack)track;
            if (this.activeTrack != null && track != null) {
                this.manager.executeTrack(this, newTrack, this.getMainConfiguration(), this.options);
                scheduled = true;
            }
        }
        return scheduled;
    }

    @Override
    public void playTrack(AudioTrack track) {
        this.startTrack(track, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startTrack(AudioTrack track, boolean noInterrupt) {
        InternalAudioTrack newTrack = (InternalAudioTrack)track;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack previousTrack = this.activeTrack;
            if (noInterrupt && previousTrack != null) {
                return false;
            }
            if (this.scheduledTrack != null) {
                this.scheduledTrack.stop();
                this.scheduledTrack = null;
            }
            this.activeTrack = newTrack;
            this.lastRequestTime = System.currentTimeMillis();
            this.lastReceiveTime = System.nanoTime();
            this.stuckEventSent = false;
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, newTrack == null ? AudioTrackEndReason.STOPPED : AudioTrackEndReason.REPLACED));
                this.shadowTrack = previousTrack;
            }
        }
        if (newTrack == null) {
            this.shadowTrack = null;
            return false;
        }
        this.dispatchEvent(new TrackStartEvent(this, newTrack));
        this.manager.executeTrack(this, newTrack, this.getMainConfiguration(), this.options);
        return true;
    }

    @Override
    public void stopCurrentTrack() {
        this.stopWithReason(AudioTrackEndReason.STOPPED, false);
    }

    @Override
    public void stopTrack() {
        this.stopWithReason(AudioTrackEndReason.STOPPED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWithReason(AudioTrackEndReason reason, boolean includeScheduled) {
        this.shadowTrack = null;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            if (includeScheduled && this.scheduledTrack != null) {
                this.scheduledTrack.stop();
                this.scheduledTrack = null;
            }
            InternalAudioTrack previousTrack = this.activeTrack;
            boolean swapped = false;
            if (this.scheduledTrack != null) {
                this.activeTrack = this.scheduledTrack;
                this.scheduledTrack = null;
                swapped = true;
            } else {
                this.activeTrack = null;
            }
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, reason));
            }
            if (swapped && this.activeTrack != null) {
                this.dispatchEvent(new TrackStartEvent(this, this.activeTrack));
            }
        }
    }

    private AudioFrame provideShadowFrame() {
        InternalAudioTrack shadow = this.shadowTrack;
        AudioFrame frame = null;
        if (shadow != null && (frame = shadow.provide()) != null && frame.isTerminator()) {
            this.shadowTrack = null;
            frame = null;
        }
        return frame;
    }

    private boolean provideShadowFrame(MutableAudioFrame targetFrame) {
        InternalAudioTrack shadow = this.shadowTrack;
        if (shadow != null && shadow.provide(targetFrame)) {
            if (targetFrame.isTerminator()) {
                this.shadowTrack = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public AudioFrame provide() {
        return AudioFrameProviderTools.delegateToTimedProvide(this);
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        InternalAudioTrack track;
        this.lastRequestTime = System.currentTimeMillis();
        if (timeout == 0L && this.paused.get()) {
            return null;
        }
        while ((track = this.activeTrack) != null) {
            AudioFrame frame;
            AudioFrame audioFrame = frame = timeout > 0L ? track.provide(timeout, unit) : track.provide();
            if (frame != null) {
                this.lastReceiveTime = System.nanoTime();
                this.shadowTrack = null;
                if (frame.isTerminator()) {
                    this.handleTerminator(track);
                    continue;
                }
            } else if (timeout == 0L) {
                this.checkStuck(track);
                frame = this.provideShadowFrame();
            }
            return frame;
        }
        return null;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        try {
            return this.provide(targetFrame, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            ExceptionTools.keepInterrupted(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        InternalAudioTrack track;
        this.lastRequestTime = System.currentTimeMillis();
        if (timeout == 0L && this.paused.get()) {
            return false;
        }
        while ((track = this.activeTrack) != null) {
            if (timeout > 0L ? track.provide(targetFrame, timeout, unit) : track.provide(targetFrame)) {
                this.lastReceiveTime = System.nanoTime();
                this.shadowTrack = null;
                if (targetFrame.isTerminator()) {
                    this.handleTerminator(track);
                    continue;
                }
                return true;
            }
            if (timeout == 0L) {
                this.checkStuck(track);
                return this.provideShadowFrame(targetFrame);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminator(InternalAudioTrack track) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            if (this.activeTrack == track) {
                AudioTrackEndReason endReason;
                this.activeTrack = null;
                boolean failedBeforeLoad = track.getActiveExecutor().failedBeforeLoad();
                boolean swapped = false;
                AudioTrackEndReason audioTrackEndReason = this.scheduledTrack != null ? (failedBeforeLoad ? AudioTrackEndReason.LOAD_FAILED_GAPLESS : AudioTrackEndReason.FINISHED_GAPLESS) : (endReason = failedBeforeLoad ? AudioTrackEndReason.LOAD_FAILED : AudioTrackEndReason.FINISHED);
                if (this.scheduledTrack != null) {
                    this.activeTrack = this.scheduledTrack;
                    this.scheduledTrack = null;
                    swapped = true;
                }
                try {
                    this.dispatchEvent(new TrackEndEvent(this, track, endReason));
                }
                finally {
                    track.stop();
                }
                if (swapped && this.activeTrack != null) {
                    this.dispatchEvent(new TrackStartEvent(this, this.activeTrack));
                }
            }
        }
    }

    private void checkStuck(AudioTrack track) {
        if (!this.stuckEventSent && System.nanoTime() - this.lastReceiveTime > this.manager.getTrackStuckThresholdNanos()) {
            this.stuckEventSent = true;
            StackTraceElement[] stackTrace = this.getStackTrace(track);
            long threshold = TimeUnit.NANOSECONDS.toMillis(this.manager.getTrackStuckThresholdNanos());
            this.dispatchEvent(new TrackStuckEvent(this, track, threshold, stackTrace));
        }
    }

    private StackTraceElement[] getStackTrace(AudioTrack track) {
        AudioTrackExecutor executor;
        if (track instanceof InternalAudioTrack && (executor = ((InternalAudioTrack)track).getActiveExecutor()) instanceof LocalAudioTrackExecutor) {
            return ((LocalAudioTrackExecutor)executor).getStackTrace();
        }
        return null;
    }

    @Override
    public int getVolume() {
        return this.options.volumeLevel.get();
    }

    @Override
    public void setVolume(int volume) {
        this.options.volumeLevel.set(Math.min(1000, Math.max(0, volume)));
    }

    @Override
    public void setFilterFactory(PcmFilterFactory factory) {
        this.options.filterFactory.set(factory);
    }

    @Override
    public void setFrameBufferDuration(Integer duration) {
        if (duration != null) {
            duration = Math.max(200, duration);
        }
        this.options.frameBufferDuration.set(duration);
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public void setPaused(boolean value) {
        if (this.paused.compareAndSet(!value, value)) {
            if (value) {
                this.dispatchEvent(new PlayerPauseEvent(this));
            } else {
                this.dispatchEvent(new PlayerResumeEvent(this));
                this.lastReceiveTime = System.nanoTime();
            }
        }
    }

    @Override
    public void destroy() {
        this.stopTrack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AudioEventListener listener) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(AudioEventListener listener) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AudioEvent event) {
        log.debug("Firing an event with class {}", (Object)event.getClass().getSimpleName());
        Object object = this.trackSwitchLock;
        synchronized (object) {
            for (AudioEventListener listener : this.listeners.items) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    log.error("Handler of event {} threw an exception.", (Object)event, (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrackException(AudioTrack track, FriendlyException exception) {
        if (track == this.scheduledTrack) {
            Object object = this.trackSwitchLock;
            synchronized (object) {
                if (track == this.scheduledTrack) {
                    this.scheduledTrack.stop();
                    this.scheduledTrack = null;
                }
            }
        }
        this.dispatchEvent(new TrackExceptionEvent(this, track, exception));
    }

    @Override
    public void onTrackStuck(AudioTrack track, long thresholdMs) {
        this.dispatchEvent(new TrackStuckEvent(this, track, thresholdMs, null));
    }

    @Override
    public void checkCleanup(long threshold) {
        AudioTrack track = this.getPlayingTrack();
        if (track != null && System.currentTimeMillis() - this.lastRequestTime >= threshold) {
            log.debug("Triggering cleanup on an audio player playing track {}", (Object)track);
            this.stopWithReason(AudioTrackEndReason.CLEANUP, true);
        }
    }
}

