/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format;

import java.util.Objects;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;

public abstract class AudioDataFormat {
    public final int channelCount;
    public final int sampleRate;
    public final int chunkSampleCount;

    public AudioDataFormat(int channelCount, int sampleRate, int chunkSampleCount) {
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
        this.chunkSampleCount = chunkSampleCount;
    }

    public int totalSampleCount() {
        return this.chunkSampleCount * this.channelCount;
    }

    public long frameDuration() {
        return (long)this.chunkSampleCount * 1000L / (long)this.sampleRate;
    }

    public abstract String codecName();

    public abstract byte[] silenceBytes();

    public abstract int expectedChunkSize();

    public abstract int maximumChunkSize();

    public abstract AudioChunkDecoder createDecoder();

    public abstract AudioChunkEncoder createEncoder(AudioConfiguration var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDataFormat that = (AudioDataFormat)o;
        if (this.channelCount != that.channelCount) {
            return false;
        }
        if (this.sampleRate != that.sampleRate) {
            return false;
        }
        if (this.chunkSampleCount != that.chunkSampleCount) {
            return false;
        }
        return Objects.equals(this.codecName(), that.codecName());
    }

    public int hashCode() {
        int result = this.channelCount;
        result = 31 * result + this.sampleRate;
        result = 31 * result + this.chunkSampleCount;
        result = 31 * result + this.codecName().hashCode();
        return result;
    }
}

