/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.volume;

import java.nio.ShortBuffer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.volume.AudioFrameVolumeChanger;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class VolumePostProcessor
implements AudioPostProcessor {
    private final PcmVolumeProcessor volumeProcessor;
    private final AudioProcessingContext context;

    public VolumePostProcessor(AudioProcessingContext context) {
        this.context = context;
        this.volumeProcessor = new PcmVolumeProcessor(context.playerOptions.volumeLevel.get());
    }

    @Override
    public void process(long timecode, ShortBuffer buffer) throws InterruptedException {
        int currentVolume = this.context.playerOptions.volumeLevel.get();
        if (currentVolume != this.volumeProcessor.getLastVolume()) {
            AudioFrameVolumeChanger.apply(this.context);
        }
        if (currentVolume != 0) {
            this.volumeProcessor.applyVolume(100, currentVolume, buffer);
        } else {
            this.volumeProcessor.setLastVolume(0);
        }
    }

    @Override
    public void close() {
    }
}

