/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.volume;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkDecoder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.ImmutableAudioFrame;

public class AudioFrameVolumeChanger
implements AudioFrameRebuilder {
    private final AudioConfiguration configuration;
    private final AudioDataFormat format;
    private final int newVolume;
    private final ShortBuffer sampleBuffer;
    private final PcmVolumeProcessor volumeProcessor;
    private AudioChunkEncoder encoder;
    private AudioChunkDecoder decoder;
    private int frameIndex;

    private AudioFrameVolumeChanger(AudioConfiguration configuration, AudioDataFormat format, int newVolume) {
        this.configuration = configuration;
        this.format = format;
        this.newVolume = newVolume;
        this.sampleBuffer = ByteBuffer.allocateDirect(format.totalSampleCount() * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.volumeProcessor = new PcmVolumeProcessor(100);
    }

    @Override
    public AudioFrame rebuild(AudioFrame frame) {
        if (frame.getVolume() == this.newVolume) {
            return frame;
        }
        this.decoder.decode(frame.getData(), this.sampleBuffer);
        int targetVolume = this.newVolume;
        if (++this.frameIndex < 50) {
            targetVolume = (int)((double)(this.newVolume - frame.getVolume()) * ((double)this.frameIndex / 50.0) + (double)frame.getVolume());
        }
        if (targetVolume != 0) {
            this.volumeProcessor.applyVolume(frame.getVolume(), targetVolume, this.sampleBuffer);
        }
        byte[] bytes = this.encoder.encode(this.sampleBuffer);
        try {
            Thread.sleep(5L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return new ImmutableAudioFrame(frame.getTimecode(), bytes, targetVolume, this.format, frame.getFlags());
    }

    private void setupLibraries() {
        this.encoder = this.format.createEncoder(this.configuration);
        this.decoder = this.format.createDecoder();
    }

    private void clearLibraries() {
        if (this.encoder != null) {
            this.encoder.close();
        }
        if (this.decoder != null) {
            this.decoder.close();
        }
    }

    public static void apply(AudioProcessingContext context) {
        AudioFrameVolumeChanger volumeChanger = new AudioFrameVolumeChanger(context.configuration, context.outputFormat, context.playerOptions.volumeLevel.get());
        try {
            volumeChanger.setupLibraries();
            context.frameBuffer.rebuild(volumeChanger);
        }
        finally {
            volumeChanger.clearLibraries();
        }
    }
}

