/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav;

import java.io.IOException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WavAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WavFileLoader;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class WavContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(WavContainerProbe.class);

    @Override
    public String getName() {
        return "wav";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, WavFileLoader.WAV_RIFF_HEADER)) {
            return null;
        }
        log.debug("Track {} is a WAV file.", (Object)reference.identifier);
        WavFileInfo fileInfo = new WavFileLoader(inputStream).parseHeaders();
        return MediaContainerDetectionResult.supportedFormat(this, null, new AudioTrackInfo(DataFormatTools.defaultOnNull(reference.title, "Unknown title"), "Unknown artist", fileInfo.getDuration(), reference.identifier, false, reference.identifier));
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new WavAudioTrack(trackInfo, inputStream);
    }
}

