/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.playlists;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;

public class ExtendedM3uParser {
    private static final Pattern directiveArgumentPattern = Pattern.compile("([A-Z-]+)=(?:\"([^\"]*)\"|([^,]*))(?:,|\\z)");

    public static Line parseLine(String line) {
        String trimmed = line.trim();
        if (trimmed.isEmpty()) {
            return Line.EMPTY_LINE;
        }
        if (!trimmed.startsWith("#")) {
            return new Line(trimmed, null, Collections.emptyMap(), null);
        }
        return ExtendedM3uParser.parseDirectiveLine(trimmed);
    }

    private static Line parseDirectiveLine(String line) {
        String[] parts = line.split(":", 2);
        if (parts.length == 1) {
            return new Line(null, line.substring(1), Collections.emptyMap(), "");
        }
        Matcher matcher = directiveArgumentPattern.matcher(parts[1]);
        HashMap<String, String> arguments = new HashMap<String, String>();
        while (matcher.find()) {
            arguments.put(matcher.group(1), DataFormatTools.defaultOnNull(matcher.group(2), matcher.group(3)));
        }
        return new Line(null, parts[0].substring(1), arguments, parts[1]);
    }

    public static class Line {
        private static final Line EMPTY_LINE = new Line(null, null, null, null);
        public final String lineData;
        public final String directiveName;
        public final Map<String, String> directiveArguments;
        public final String extraData;

        private Line(String lineData, String directiveName, Map<String, String> directiveArguments, String extraData) {
            this.lineData = lineData;
            this.directiveName = directiveName;
            this.directiveArguments = directiveArguments;
            this.extraData = extraData;
        }

        public boolean isDirective() {
            return this.directiveName != null;
        }

        public boolean isData() {
            return this.lineData != null;
        }
    }
}

