/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacMetadataHeader;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacSeekPoint;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfoBuilder;
import org.apache.commons.io.IOUtils;

public class FlacMetadataReader {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static FlacStreamInfo readStreamInfoBlock(DataInput dataInput) throws IOException {
        FlacMetadataHeader header = FlacMetadataReader.readMetadataHeader(dataInput);
        if (header.blockType != 0) {
            throw new IllegalStateException("Wrong metadata block, should be stream info.");
        }
        if (header.blockLength != 34) {
            throw new IllegalStateException("Invalid stream info block size.");
        }
        byte[] streamInfoData = new byte[34];
        dataInput.readFully(streamInfoData);
        return new FlacStreamInfo(streamInfoData, !header.isLastBlock);
    }

    private static FlacMetadataHeader readMetadataHeader(DataInput dataInput) throws IOException {
        byte[] headerBytes = new byte[4];
        dataInput.readFully(headerBytes);
        return new FlacMetadataHeader(headerBytes);
    }

    public static boolean readMetadataBlock(DataInput dataInput, InputStream inputStream, FlacTrackInfoBuilder trackInfoBuilder) throws IOException {
        FlacMetadataHeader header = FlacMetadataReader.readMetadataHeader(dataInput);
        if (header.blockType == 3) {
            FlacMetadataReader.readSeekTableBlock(dataInput, trackInfoBuilder, header.blockLength);
        } else if (header.blockType == 4) {
            FlacMetadataReader.readCommentBlock(dataInput, inputStream, trackInfoBuilder);
        } else {
            IOUtils.skipFully((InputStream)inputStream, (long)header.blockLength);
        }
        return !header.isLastBlock;
    }

    private static void readCommentBlock(DataInput dataInput, InputStream inputStream, FlacTrackInfoBuilder trackInfoBuilder) throws IOException {
        int vendorLength = Integer.reverseBytes(dataInput.readInt());
        IOUtils.skipFully((InputStream)inputStream, (long)vendorLength);
        int listLength = Integer.reverseBytes(dataInput.readInt());
        for (int i = 0; i < listLength; ++i) {
            int itemLength = Integer.reverseBytes(dataInput.readInt());
            byte[] textBytes = new byte[itemLength];
            dataInput.readFully(textBytes);
            String text = new String(textBytes, CHARSET);
            String[] keyAndValue = text.split("=", 2);
            if (keyAndValue.length <= 1) continue;
            trackInfoBuilder.addTag(keyAndValue[0].toUpperCase(), keyAndValue[1]);
        }
    }

    private static void readSeekTableBlock(DataInput dataInput, FlacTrackInfoBuilder trackInfoBuilder, int length) throws IOException {
        FlacSeekPoint[] seekPoints = new FlacSeekPoint[length / 18];
        int seekPointCount = 0;
        for (int i = 0; i < seekPoints.length; ++i) {
            long sampleIndex = dataInput.readLong();
            long byteOffset = dataInput.readLong();
            int sampleCount = dataInput.readUnsignedShort();
            seekPoints[i] = new FlacSeekPoint(sampleIndex, byteOffset, sampleCount);
            if (sampleIndex == -1L) continue;
            seekPointCount = i + 1;
        }
        trackInfoBuilder.setSeekPoints(seekPoints, seekPointCount);
    }
}

