/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacMetadataReader;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfoBuilder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class FlacFileLoader {
    static final int[] FLAC_CC = new int[]{102, 76, 97, 67};
    private final SeekableInputStream inputStream;
    private final DataInput dataInput;

    public FlacFileLoader(SeekableInputStream inputStream) {
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
    }

    public FlacTrackInfo parseHeaders() throws IOException {
        if (!MediaContainerDetection.checkNextBytes(this.inputStream, FLAC_CC, false)) {
            throw new IllegalStateException("Not a FLAC file");
        }
        FlacTrackInfoBuilder trackInfoBuilder = new FlacTrackInfoBuilder(FlacMetadataReader.readStreamInfoBlock(this.dataInput));
        this.readMetadataBlocks(trackInfoBuilder);
        trackInfoBuilder.setFirstFramePosition(this.inputStream.getPosition());
        return trackInfoBuilder.build();
    }

    public FlacTrackProvider loadTrack(AudioProcessingContext context) throws IOException {
        return new FlacTrackProvider(context, this.parseHeaders(), this.inputStream);
    }

    private void readMetadataBlocks(FlacTrackInfoBuilder trackInfoBuilder) throws IOException {
        boolean hasMoreBlocks = trackInfoBuilder.getStreamInfo().hasMetadataBlocks;
        while (hasMoreBlocks) {
            hasMoreBlocks = FlacMetadataReader.readMetadataBlock(this.dataInput, this.inputStream, trackInfoBuilder);
        }
    }
}

