/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.grack.nanojson;

import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import mods.thecomputerizer.shadow.com.grack.nanojson.JsonArray;
import mods.thecomputerizer.shadow.com.grack.nanojson.JsonObject;
import mods.thecomputerizer.shadow.com.grack.nanojson.JsonSink;
import mods.thecomputerizer.shadow.com.grack.nanojson.JsonWriterException;

public final class JsonBuilder<T>
implements JsonSink<JsonBuilder<T>> {
    private Stack<Object> json = new Stack();
    private String pendingKey;
    private T root;

    JsonBuilder(T t) {
        this.root = t;
        this.json.push(t);
    }

    public T done() {
        return this.root;
    }

    @Override
    public JsonBuilder<T> array(Collection<?> collection) {
        return this.value(collection);
    }

    @Override
    public JsonBuilder<T> array(String string, Collection<?> collection) {
        return this.value(string, collection);
    }

    @Override
    public JsonBuilder<T> object(Map<?, ?> map) {
        return this.value(map);
    }

    @Override
    public JsonBuilder<T> object(String string, Map<?, ?> map) {
        return this.value(string, map);
    }

    @Override
    public JsonBuilder<T> nul() {
        return this.value((Object)null);
    }

    @Override
    public JsonBuilder<T> nul(String string) {
        return this.value(string, (Object)null);
    }

    @Override
    public JsonBuilder<T> value(Object object) {
        if (this.pendingKey != null) {
            this.obj().put(this.pendingKey, object);
            this.pendingKey = null;
        } else {
            this.arr().add(object);
        }
        return this;
    }

    @Override
    public JsonBuilder<T> value(String string, Object object) {
        if (this.pendingKey != null) {
            throw new JsonWriterException("Invalid call to emit a key value immediately after emitting a key");
        }
        this.obj().put(string, object);
        return this;
    }

    @Override
    public JsonBuilder<T> value(String string) {
        return this.value((Object)string);
    }

    @Override
    public JsonBuilder<T> value(int n) {
        return this.value((Object)n);
    }

    @Override
    public JsonBuilder<T> value(long l) {
        return this.value((Object)l);
    }

    @Override
    public JsonBuilder<T> value(boolean bl) {
        return this.value((Object)bl);
    }

    @Override
    public JsonBuilder<T> value(double d) {
        return this.value((Object)d);
    }

    @Override
    public JsonBuilder<T> value(float f) {
        return this.value((Object)Float.valueOf(f));
    }

    @Override
    public JsonBuilder<T> value(Number number) {
        return this.value((Object)number);
    }

    @Override
    public JsonBuilder<T> value(String string, String string2) {
        return this.value(string, (Object)string2);
    }

    @Override
    public JsonBuilder<T> value(String string, int n) {
        return this.value(string, (Object)n);
    }

    @Override
    public JsonBuilder<T> value(String string, long l) {
        return this.value(string, (Object)l);
    }

    @Override
    public JsonBuilder<T> value(String string, boolean bl) {
        return this.value(string, (Object)bl);
    }

    @Override
    public JsonBuilder<T> value(String string, double d) {
        return this.value(string, (Object)d);
    }

    @Override
    public JsonBuilder<T> value(String string, float f) {
        return this.value(string, (Object)Float.valueOf(f));
    }

    @Override
    public JsonBuilder<T> value(String string, Number number) {
        return this.value(string, (Object)number);
    }

    @Override
    public JsonBuilder<T> array() {
        JsonArray jsonArray = new JsonArray();
        this.value(jsonArray);
        this.json.push(jsonArray);
        return this;
    }

    @Override
    public JsonBuilder<T> object() {
        JsonObject jsonObject = new JsonObject();
        this.value(jsonObject);
        this.json.push(jsonObject);
        return this;
    }

    @Override
    public JsonBuilder<T> array(String string) {
        JsonArray jsonArray = new JsonArray();
        this.value(string, jsonArray);
        this.json.push(jsonArray);
        return this;
    }

    @Override
    public JsonBuilder<T> object(String string) {
        JsonObject jsonObject = new JsonObject();
        this.value(string, jsonObject);
        this.json.push(jsonObject);
        return this;
    }

    @Override
    public JsonBuilder<T> end() {
        if (this.json.size() == 1) {
            throw new JsonWriterException("Cannot end the root object or array");
        }
        this.json.pop();
        return this;
    }

    @Override
    public JsonBuilder<T> key(String string) {
        if (string == null) {
            throw new NullPointerException("key");
        }
        if (!(this.json.peek() instanceof JsonObject)) {
            throw new JsonWriterException("Invalid call to emit a key value while not writing an object");
        }
        if (this.pendingKey != null) {
            throw new JsonWriterException("Invalid call to emit a key value immediately after emitting a key");
        }
        this.pendingKey = string;
        return this;
    }

    private JsonObject obj() {
        try {
            return (JsonObject)this.json.peek();
        }
        catch (ClassCastException classCastException) {
            throw new JsonWriterException("Attempted to write a keyed value to a JsonArray");
        }
    }

    private JsonArray arr() {
        try {
            return (JsonArray)this.json.peek();
        }
        catch (ClassCastException classCastException) {
            throw new JsonWriterException("Attempted to write a non-keyed value to a JsonObject");
        }
    }
}

