/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.server;

import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.network.MessageRequestChannels;
import mods.thecomputerizer.musictriggers.api.server.MTCommands;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.CommonEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.EventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.events.PlayerLoggedInEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.events.PlayerLoggedOutEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.events.RegisterCommandsEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.common.event.types.CommonTickableEventType;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.server.event.ServerEventWrapper;
import mods.thecomputerizer.theimpossiblelibrary.api.server.event.events.ServerTickEventWrapper;

public class MTServerEvents {
    static int ticksUntilReload = -1;

    public static void init() {
        MTRef.logInfo("Initializing server event invokers", new Object[0]);
        EventHelper.addListener((EventWrapper.EventType)CommonEventWrapper.CommonType.PLAYER_LOGGED_IN, MTServerEvents::onPlayerJoin);
        EventHelper.addListener((EventWrapper.EventType)CommonEventWrapper.CommonType.PLAYER_LOGGED_OUT, MTServerEvents::onPlayerLeave);
        EventHelper.addListener((EventWrapper.EventType)CommonEventWrapper.CommonType.REGISTER_COMMANDS, MTServerEvents::onRegisterCommands);
        EventHelper.addListener((EventWrapper.EventType)ServerEventWrapper.ServerType.TICK_SERVER, MTServerEvents::onServerTick);
    }

    public static void onServerTick(ServerTickEventWrapper<?> wrapper) {
        if (ticksUntilReload < 0) {
            return;
        }
        if (wrapper.isPhase(CommonTickableEventType.TickPhase.END)) {
            if (ticksUntilReload == 0) {
                ChannelHelper.reload(false);
            }
            --ticksUntilReload;
        }
    }

    public static void onPlayerJoin(PlayerLoggedInEventWrapper<?> wrapper) {
        PlayerAPI player = wrapper.getPlayer();
        String uuid = player.getUUID().toString();
        MTRef.logInfo("Found joining player with UUID {}", uuid);
        MTNetwork.sendToClient(new MessageRequestChannels(uuid, false), false, player);
    }

    public static void onPlayerLeave(PlayerLoggedOutEventWrapper<?> wrapper) {
        PlayerAPI player = wrapper.getPlayer();
        String uuid = player.getUUID().toString();
        MTRef.logInfo("Found leaving player with UUID {}", uuid);
        ChannelHelper.closePlayerChannel(uuid);
    }

    public static void onRegisterCommands(RegisterCommandsEventWrapper<?> wrapper) {
        MTRef.logInfo("Registering commands", new Object[0]);
        wrapper.registerCommand((CommandAPI)MTCommands.root("musictriggers"));
        wrapper.registerCommand((CommandAPI)MTCommands.root("mt"));
    }

    public static void queueServerReload(int ticks) {
        ChannelHelper.onReloadQueued(false);
        MinecraftServerAPI server = ServerHelper.getAPI();
        if (ticks > 0 && Objects.nonNull(server)) {
            server.executeCommandLiteral("say Music Triggers will reload in " + ticks + " ticks");
        }
        ticksUntilReload = ticks;
    }
}

