/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.network.MessageNBTCheck;
import mods.thecomputerizer.musictriggers.api.network.MessageReload;
import mods.thecomputerizer.musictriggers.api.network.MessageSeekSong;
import mods.thecomputerizer.musictriggers.api.network.MessageSkipSong;
import mods.thecomputerizer.musictriggers.api.network.MessageToggleDebugParameter;
import mods.thecomputerizer.musictriggers.api.server.MTServerEvents;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextTranslationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;

public class MTCommands
extends CommandAPI {
    static final String[] NON_EXECUTABLE_SUBTYPES = new String[]{"query", "seek", "trigger"};
    static final String[] QUERY_TYPES = new String[]{"nbt"};
    static final String[] SUBTYPES = new String[]{"debug", "query", "reload", "seek", "skip", "trigger"};

    public static MTCommands root(String name) {
        return new MTCommands(name, null, CommandAPI.ArgType.ROOT, false);
    }

    public MTCommands(String name, CommandAPI parent, CommandAPI.ArgType type, boolean executionNode) {
        super(name, parent, type, executionNode);
        for (String typeName : SUBTYPES) {
            this.addSubCommand(typeName, this, CommandAPI.ArgType.LITERAL);
        }
    }

    void addSubCommand(String typeName, CommandAPI parent, CommandAPI.ArgType type) {
        MTSubCommand sub = new MTSubCommand(typeName, parent, type, !Misc.equalsAny((Object)typeName, (Object[])NON_EXECUTABLE_SUBTYPES));
        switch (typeName) {
            case "debug": {
                this.addSubCommand("parameter", sub, CommandAPI.ArgType.STRING);
            }
            case "query": {
                this.addSubCommand("query_type", sub, CommandAPI.ArgType.STRING);
            }
            case "reload": {
                this.addSubCommand("ticks", sub, CommandAPI.ArgType.INTEGER);
            }
            case "seek": {
                this.addSubCommand("seconds", sub, CommandAPI.ArgType.INTEGER);
            }
            case "trigger": {
                this.addSubCommand("identifier", sub, CommandAPI.ArgType.STRING);
            }
        }
        this.addSubCommand(sub);
    }

    public void execute(MinecraftServerAPI<?> server, CommandSenderAPI<?> sender, String input, String remaining) {
        throw new IllegalArgumentException("too few arguments");
    }

    public List<String> getTabCompletions(MinecraftServerAPI<?> minecraftServerAPI, CommandSenderAPI<?> commandSenderAPI, String input, String remaining) {
        return Collections.emptyList();
    }

    public void prepareExceptionInfo() {
        this.exceptionKey = this.getMessageKey(new String[]{"usage"});
    }

    static class MTSubCommand
    extends CommandAPI {
        public MTSubCommand(String name, CommandAPI parent, CommandAPI.ArgType type, boolean executionNode) {
            super(name, parent, type, executionNode);
        }

        public void execute(MinecraftServerAPI<?> server, CommandSenderAPI<?> sender, String input, String remaining) {
            ChannelHelper.logGlobalDebug("Executing command on server with args {} {}", input, remaining);
            Object entity = this.unwrapEntity(sender);
            switch (this.getName()) {
                case "debug": {
                    ChannelHelper.logGlobalDebug("Sending debug packet", new Object[0]);
                    MTNetwork.sendToClient(new MessageToggleDebugParameter(false, "enable_debug_info"), false, entity);
                    sender.sendMessage((TextAPI)TextHelper.getTranslated((String)this.getMessageKey(new String[]{"success"}), (Object[])new Object[0]));
                    break;
                }
                case "identifier": {
                    TextTranslationAPI msg;
                    if (Objects.nonNull(entity)) {
                        PlayerAPI player = WrapperHelper.wrapPlayer((Object)entity);
                        String error = ChannelHelper.executeCommandTrigger(player, remaining);
                        String msgType = Objects.nonNull(error) ? "error" : "success";
                        msg = TextHelper.getTranslated((String)this.getMessageKey(new String[]{msgType}), (Object[])new Object[]{remaining});
                    } else {
                        msg = TextHelper.getTranslated((String)this.getMessageKey(new String[]{"player"}), (Object[])new Object[]{remaining});
                    }
                    if (!Objects.nonNull(msg)) break;
                    sender.sendMessage((TextAPI)msg);
                    break;
                }
                case "parameter": {
                    ChannelHelper.logGlobalDebug("Sending debug packet", new Object[0]);
                    MTNetwork.sendToClient(new MessageToggleDebugParameter(false, remaining), false, entity);
                    sender.sendMessage((TextAPI)TextHelper.getTranslated((String)this.getMessageKey(new String[]{"success"}), (Object[])new Object[]{remaining}));
                    break;
                }
                case "query_type": {
                    if ("nbt".equals(remaining)) {
                        MTNetwork.sendToClient(new MessageNBTCheck(), false, entity);
                        break;
                    }
                    sender.sendMessage((TextAPI)TextHelper.getTranslated((String)this.getMessageKey(new String[]{"unknown"}), (Object[])new Object[]{remaining}));
                    break;
                }
                case "reload": {
                    if (Objects.nonNull(entity)) {
                        ChannelHelper.logGlobalDebug("Sending reload packet", new Object[0]);
                        MTNetwork.sendToClient(new MessageReload(5), false, entity);
                        break;
                    }
                    ChannelHelper.logGlobalInfo("Reloading from the server", new Object[0]);
                    MTServerEvents.queueServerReload(5);
                    break;
                }
                case "seconds": {
                    ChannelHelper.logGlobalDebug("Sending seek packet", new Object[0]);
                    String[] splitRemaining = remaining.split(" ");
                    long seconds = Long.parseLong(splitRemaining.length == 1 ? splitRemaining[0] : splitRemaining[1]);
                    String channel = splitRemaining.length > 1 ? splitRemaining[0] : "-";
                    MTNetwork.sendToClient(new MessageSeekSong(channel, seconds), false, entity);
                    sender.sendMessage((TextAPI)TextHelper.getTranslated((String)this.getMessageKey(new String[]{"success"}), (Object[])new Object[]{seconds}));
                    break;
                }
                case "skip": {
                    ChannelHelper.logGlobalDebug("Sending skip packet", new Object[0]);
                    MTNetwork.sendToClient(new MessageSkipSong(), false, entity);
                    sender.sendMessage((TextAPI)TextHelper.getTranslated((String)this.getMessageKey(new String[]{"success"}), (Object[])new Object[0]));
                    break;
                }
                case "ticks": {
                    int ticks = RandomHelper.randomInt((String)"reload_ticks", (String)remaining, (int)5);
                    if (Objects.nonNull(entity)) {
                        ChannelHelper.logGlobalDebug("Sending reload packet", new Object[0]);
                        MTNetwork.sendToClient(new MessageReload(ticks), false, entity);
                        break;
                    }
                    ChannelHelper.logGlobalInfo("Reloading from the server", new Object[0]);
                    MTServerEvents.queueServerReload(ticks);
                    break;
                }
                default: {
                    MTRef.logError("Unknown command type {}", this.getName());
                }
            }
        }

        public List<String> getTabCompletions(MinecraftServerAPI<?> server, CommandSenderAPI<?> sender, String input, String remaining) {
            List<String> suggestions = new ArrayList<String>(Arrays.asList(SUBTYPES));
            if (this.parent instanceof MTSubCommand) {
                if (input.contains(this.parent.getName())) {
                    switch (this.getName()) {
                        case "identifier:": {
                            EntityAPI entity = sender.getEntity();
                            if (Objects.isNull(entity) || !entity.isPlayer() || remaining.isEmpty()) {
                                suggestions.clear();
                                break;
                            }
                            PlayerAPI player = WrapperHelper.wrapPlayer((Object)entity.getEntity());
                            suggestions = ChannelHelper.getCommandIdentifiers(player);
                            suggestions.removeIf(s -> !s.startsWith(remaining));
                            break;
                        }
                        case "parameter": {
                            if (remaining.isEmpty()) {
                                suggestions.clear();
                                break;
                            }
                            suggestions = ChannelHelper.getGlobalData().getDebug().getBooleanParameterNames();
                            suggestions.removeIf(s -> !s.startsWith(remaining));
                            break;
                        }
                        case "query_type": {
                            suggestions = new ArrayList<String>(Arrays.asList(QUERY_TYPES));
                            suggestions.removeIf(s -> !s.startsWith(remaining));
                            break;
                        }
                        default: {
                            suggestions.clear();
                            break;
                        }
                    }
                } else {
                    suggestions.clear();
                }
            } else {
                suggestions.removeIf(s -> !s.startsWith(remaining));
            }
            MTRef.logDebug("Returning suggestions {}", suggestions);
            return suggestions;
        }

        protected boolean isValidString(String input) {
            return TextHelper.isNotBlank((String)input);
        }

        public void prepareExceptionInfo() {
            if (Objects.nonNull(this.parent)) {
                this.parent.prepareExceptionInfo();
            }
        }
    }
}

