/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.server;

import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;

public class ChannelServer
extends ChannelAPI {
    protected AudioRef currentSong;

    public ChannelServer(ChannelHelper helper, Toml table) {
        super(helper, table);
    }

    @Override
    public boolean checkDeactivate(TriggerAPI current, TriggerAPI next) {
        return Objects.isNull(current) ? Objects.nonNull(next) : !current.equals(next);
    }

    @Override
    @Nullable
    public String getFormattedSongTime() {
        this.logError("Tried to get the time of the playing song on the server!", new Object[0]);
        return null;
    }

    @Override
    public String getLogType() {
        return "SERVER";
    }

    @Override
    public AudioPlayer getPlayer() {
        this.logError("Tried to get AudioPlayer instance on the server!", new Object[0]);
        return null;
    }

    @Override
    @Nullable
    public AudioPool getPlayingPool() {
        this.logError("Tried to get the playing audio pool instance on the server!", new Object[0]);
        return null;
    }

    @Override
    @Nullable
    public String getPlayingSongName() {
        return Objects.nonNull(this.currentSong) ? this.currentSong.getName() : "null";
    }

    @Override
    public long getPlayingSongTime() {
        this.logError("Tried to get the time of the playing song on the server!", new Object[0]);
        return 0L;
    }

    @Override
    public long getPlayingSongTotalTime() {
        this.logError("Tried to get the total time of the playing song on the server!", new Object[0]);
        return 0L;
    }

    @Override
    public boolean isClientChannel() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String loadLocalTrack(AudioRef ref, String location) {
        this.logError("Tried to load local audio track on the server!", new Object[0]);
        return null;
    }

    @Override
    public String loadRemoteTrack(AudioRef ref, String location) {
        this.logError("Tried to load remote audio track on the server!", new Object[0]);
        return null;
    }

    @Override
    public void onResourcesLoaded() {
        this.logError("onResourcesLoaded called on the server!", new Object[0]);
    }

    @Override
    public void onTrackStart(AudioTrack track) {
        this.logError("onTrackStart called on the server!", new Object[0]);
    }

    @Override
    public void onTrackStop(AudioTrackEndReason endReason) {
        this.logError("onTrackStop called on the server! {}", new Object[]{endReason});
    }

    @Override
    public void seek(long ms) {
        this.logError("Tried to seek on the server!", new Object[0]);
    }

    @Override
    public void setCategoryVolume(float volume) {
        this.logError("Tried to set category volume on the server!", new Object[0]);
    }

    public void setCurrentSong(AudioRef ref) {
        this.currentSong = ref;
        if (ref.getPlayState() == 4) {
            TriggerAPI trigger = this.getActiveTrigger();
            if (Objects.nonNull(trigger)) {
                AudioPool pool = trigger.getAudioPool();
                if (Objects.nonNull(pool)) {
                    pool.markPlayed(ref);
                } else {
                    trigger.logError("Failed to save play state of for {} (play_once = 4)", ref);
                }
            } else {
                this.logError("Failed to save play state of for {} (play_once = 4)", ref);
            }
        }
    }

    @Override
    public void setMasterVolume(float volume) {
        this.logError("Tried to set master volume on the server!", new Object[0]);
    }

    @Override
    public void setTrackVolume(float volume) {
        this.logError("Tried to set track volume on the server!", new Object[0]);
    }

    @Override
    public boolean shouldBlockMusicTicker() {
        this.logError("Tried query the vanilla music ticker on the server!", new Object[0]);
        return false;
    }
}

