/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.registry.MTBlockRegistry;
import mods.thecomputerizer.musictriggers.api.registry.MTItemRegistry;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;

public class MTBlockEntityRegistry {
    public static final BlockEntityAPI<?, ?> MUSIC_RECORDER_ENTITY = (BlockEntityAPI)RegistryHelper.makeBlockEntityBuilder().setRegistryName(MTRef.res("music_recorder_entity")).setValidBlocks(() -> Collections.singleton(MTBlockRegistry.MUSIC_RECORDER)).setOnTick(entity -> {
        BlockStateAPI state = entity.getState();
        if (Objects.nonNull(state)) {
            boolean recording = state.getPropertyBool("recording");
            boolean recordingSpecial = state.getPropertyBool("recording_special");
            if ((recording || recordingSpecial) && RandomHelper.randomDouble((double)1.0) <= 0.005) {
                BlockPosAPI pos;
                List<PlayerAPI<?, ?>> players = ChannelHelper.getPlayers(false);
                if (players.isEmpty()) {
                    MTRef.logError("Unable to record music when there are no players online!", new Object[0]);
                    return;
                }
                WorldAPI world = entity.getWorld();
                if (MTBlockEntityRegistry.spawnRecordedDisc(world, pos = entity.getPos(), recordingSpecial)) {
                    MTRef.logInfo("Successfully spawned {}music disc", recordingSpecial ? "special " : "");
                    world.setState(pos, state.withProperty("recording", (Comparable)Boolean.valueOf(false)).withProperty("recording_special", (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }).build();

    public static BlockEntityAPI<?, ?> createRecorderEntity(WorldAPI<?> world, BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        return MUSIC_RECORDER_ENTITY.createFromReference(world, pos, state);
    }

    @Nullable
    public static PlayerAPI<?, ?> findClosestPlayerInWorld(WorldAPI<?> world, BlockPosAPI<?> pos, Collection<? extends PlayerAPI<?, ?>> players) {
        String dimName = String.valueOf(world.getDimension().getRegistryName().getWrapped());
        PlayerAPI<?, ?> closest = null;
        double minDist = Double.MAX_VALUE;
        for (PlayerAPI<?, ?> player : players) {
            double distance;
            if (!dimName.equals(String.valueOf(player.getDimension().getRegistryName().getWrapped())) || !((distance = pos.distanceTo(player.getPosRounded())) < minDist)) continue;
            closest = player;
            minDist = distance;
        }
        return closest;
    }

    private static boolean spawnRecordedDisc(WorldAPI<?> world, BlockPosAPI<?> pos, boolean special) {
        if (!world.isClient()) {
            MinecraftServerAPI server = ServerHelper.getAPI();
            if (Objects.isNull(server)) {
                MTRef.logError("Cannot spawn disc in nonexistant server!", new Object[0]);
                return false;
            }
            PlayerAPI<?, ?> closestPlayer = MTBlockEntityRegistry.findClosestPlayerInWorld(world, pos, server.getPlayers());
            if (Objects.isNull(closestPlayer)) {
                MTRef.logWarn("Cannot record disc without any players in the same dimension!", new Object[0]);
                return false;
            }
            ChannelHelper helper = ChannelHelper.getHelper(String.valueOf(closestPlayer.getUUID()), false);
            if (Objects.isNull(helper)) {
                MTRef.logError("Unable to find ChannelHelper for player with UUID {}", closestPlayer.getUUID());
                return false;
            }
            Vector3 spawnPos = new Vector3((Number)RandomHelper.randomDouble((double)((double)pos.x() + 0.7), (double)((double)pos.x() + 0.85)), (Number)RandomHelper.randomDouble((double)((double)pos.y() + 0.7), (double)((double)pos.y() + 1.36)), (Number)RandomHelper.randomDouble((double)((double)pos.z() + 0.7), (double)((double)pos.z() + 0.85)));
            world.spawnItem(MTItemRegistry.ENHANCED_MUSIC_DISC, spawnPos, stack -> helper.writeDisc((ItemStackAPI<?>)stack, special), entity -> entity.setPosition((double)pos.x(), (double)pos.y() + 0.5, (double)pos.z()));
            return true;
        }
        return false;
    }
}

