/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.network;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;

public class MessageSeekSong<CTX>
extends MessageAPI<CTX> {
    private final String channel;
    private final long seconds;

    public MessageSeekSong(String channel, long seconds) {
        this.channel = Objects.nonNull(channel) && !channel.isEmpty() ? channel : "-";
        this.seconds = seconds;
    }

    public MessageSeekSong(ByteBuf buf) {
        this.channel = NetworkHelper.readString((ByteBuf)buf);
        this.seconds = buf.readLong();
    }

    public void encode(ByteBuf buf) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.channel);
        buf.writeLong(this.seconds);
    }

    public MessageAPI<CTX> handle(CTX ctx) {
        ChannelHelper helper = ChannelHelper.getClientHelper();
        if (Objects.nonNull(helper)) {
            helper.seek(this.channel, this.seconds);
        }
        return null;
    }
}

