/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.network.PlayerMessage;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParsingException;

public class MessageInitChannels<CTX>
extends PlayerMessage<CTX> {
    final boolean client;
    final Toml global;
    final Toml toggles;
    final Map<String, ChannelMessage> channels;

    public MessageInitChannels(Toml global, Toml toggles, ChannelHelper helper) {
        super(helper.getPlayerID());
        this.client = helper.isClient();
        this.global = global;
        this.toggles = toggles;
        this.channels = this.getChannelMap(helper);
        ChannelHelper.logGlobalInfo("Constructued init message", new Object[0]);
    }

    public MessageInitChannels(ByteBuf buf) {
        super(buf);
        this.client = !buf.readBoolean();
        this.global = Toml.readBuf((ByteBuf)buf);
        this.toggles = Toml.readBuf((ByteBuf)buf);
        this.channels = NetworkHelper.readMapEntries((ByteBuf)buf, () -> {
            String key = NetworkHelper.readString((ByteBuf)buf);
            return IterableHelper.getMapEntry((Object)key, (Object)new ChannelMessage(buf));
        });
        ChannelHelper.logGlobalInfo("Decodeded init message on the {} side", this.client ? "client" : "server");
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        buf.writeBoolean(this.client);
        this.global.write(buf);
        this.toggles.write(buf);
        NetworkHelper.writeMap((ByteBuf)buf, this.channels, name -> NetworkHelper.writeString((ByteBuf)buf, (String)name), channel -> channel.write(buf));
    }

    Map<String, ChannelMessage> getChannelMap(ChannelHelper helper) {
        HashMap<String, ChannelMessage> map = new HashMap<String, ChannelMessage>();
        for (ChannelAPI channel : helper.getChannels().values()) {
            String name = channel.getName();
            if ("jukebox".equals(name) || "preview".equals(name)) continue;
            map.put(name, new ChannelMessage(channel));
        }
        return map;
    }

    public MessageAPI<CTX> handle(CTX ctx) {
        return ChannelHelper.loadMessage(this);
    }

    @Generated
    public boolean isClient() {
        return this.client;
    }

    @Generated
    public Toml getGlobal() {
        return this.global;
    }

    @Generated
    public Toml getToggles() {
        return this.toggles;
    }

    @Generated
    public Map<String, ChannelMessage> getChannels() {
        return this.channels;
    }

    public static class ChannelMessage {
        final Map<String, Toml> tomls;
        final Set<String> redirects;
        final Set<String> records;

        ChannelMessage(ChannelAPI channel) {
            this.tomls = channel.getSourceMap();
            this.redirects = channel.getRedirectLines();
            this.records = channel.getRecordLines();
        }

        ChannelMessage(ByteBuf buf) {
            this.tomls = NetworkHelper.readMap((ByteBuf)buf, () -> NetworkHelper.readString((ByteBuf)buf), () -> {
                try {
                    return Toml.readBuf((ByteBuf)buf);
                }
                catch (TomlParsingException ex) {
                    ChannelHelper.logGlobalError("Failed to read TOML from buffer!", new Object[]{ex});
                    return Toml.getEmpty();
                }
            });
            this.redirects = NetworkHelper.readSet((ByteBuf)buf, () -> NetworkHelper.readString((ByteBuf)buf));
            this.records = NetworkHelper.readSet((ByteBuf)buf, () -> NetworkHelper.readString((ByteBuf)buf));
        }

        void write(ByteBuf buf) {
            NetworkHelper.writeMap((ByteBuf)buf, this.tomls, key -> NetworkHelper.writeString((ByteBuf)buf, (String)key), toml -> toml.write(buf));
            NetworkHelper.writeSet((ByteBuf)buf, this.redirects, redirect -> NetworkHelper.writeString((ByteBuf)buf, (String)redirect));
            NetworkHelper.writeSet((ByteBuf)buf, this.records, record -> NetworkHelper.writeString((ByteBuf)buf, (String)record));
        }

        @Generated
        public Map<String, Toml> getTomls() {
            return this.tomls;
        }

        @Generated
        public Set<String> getRedirects() {
            return this.redirects;
        }

        @Generated
        public Set<String> getRecords() {
            return this.records;
        }
    }
}

