/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger.holder;

import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;

public class TriggerHeight
extends HolderTrigger {
    public TriggerHeight(ChannelAPI channel) {
        super(channel, "height");
    }

    @Override
    public boolean imply(String id) {
        try {
            int level = Integer.parseInt(id);
            this.setExistingParameterValue("level", level);
        }
        catch (NumberFormatException ex) {
            this.logError("Failed to imply level from identifier {} (must be an integer)", id, ex);
        }
        return super.imply(id);
    }

    @Override
    public boolean isPlayableContext(TriggerContext ctx) {
        return ctx.isActiveHeight(this.getParameterAsInt("level"), this.getParameterAsBoolean("check_for_sky"), this.getParameterAsBoolean("check_above_level"));
    }

    @Override
    public boolean verifyRequiredParameters() {
        String[] parameters = new String[]{"identifier", "level"};
        if (this.hasAllNonDefaultParameter(parameters)) {
            return true;
        }
        this.logMissingParameters(parameters);
        return false;
    }
}

