/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;

public class TriggerSynced
extends TriggerAPI {
    private final TriggerAPI reference;
    private TriggerAPI.State syncedState;

    public TriggerSynced(ChannelAPI channel, TriggerAPI reference) {
        super(channel, "synced");
        this.reference = reference;
        this.syncedState = Objects.nonNull((Object)reference.getState()) ? reference.getState() : TriggerAPI.State.IDLE;
    }

    @Override
    public boolean canActivate() {
        return this.getState() == TriggerAPI.State.ACTIVE && this.hasNonEmptyAudioPool();
    }

    @Override
    public String getNameWithID() {
        return this.reference.getNameWithID();
    }

    @Override
    public Parameter<?> getParameter(String name) {
        return this.reference.getParameter(name);
    }

    @Override
    public TriggerAPI.State getState() {
        return this.syncedState;
    }

    @Override
    public TriggerAPI.State getSyncedState() {
        return this.getState();
    }

    @Override
    public boolean isPlayableContext(TriggerContext context) {
        return this.syncedState == TriggerAPI.State.PLAYABLE || this.syncedState == TriggerAPI.State.ACTIVE;
    }

    @Override
    public boolean isSynced() {
        return true;
    }

    @Override
    public void setState(TriggerAPI.State state) {
        if (this.syncedState.isPlayable() && state.isPlayable()) {
            this.syncedState = state;
        }
    }

    @Override
    public boolean matches(TriggerAPI trigger) {
        return this.reference.matches(trigger);
    }

    @Override
    public void setUniversals(UniversalParameters universals) {
        super.setUniversals(universals);
        this.reference.setUniversals(universals);
    }

    public void sync(TriggerAPI.State state) {
        this.syncedState = state;
    }

    @Generated
    public TriggerAPI getReference() {
        return this.reference;
    }
}

