/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelData;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerMerged;
import mods.thecomputerizer.musictriggers.api.data.trigger.basic.BasicTrigger;

public class TriggerSelector
extends ChannelElement {
    protected final TriggerContext context;
    protected TriggerAPI activeTrigger;
    protected TriggerAPI activeNonFadingTrigger;
    protected TriggerAPI previousTrigger;
    protected AudioPool activePool;
    protected AudioPool previousPool;
    protected String crashHelper = "";
    private boolean cleared;

    public TriggerSelector(ChannelAPI channel, TriggerContext context) {
        super(channel, "selector");
        this.context = context;
    }

    public void clear() {
        this.activeTrigger = null;
        this.previousTrigger = null;
        this.activePool = null;
        this.previousPool = null;
        this.crashHelper = "cleared";
    }

    @Override
    public void close() {
        this.clear();
    }

    protected Collection<TriggerAPI> collectPlayableTriggers(Collection<TriggerAPI> triggers, boolean unpaused) {
        this.setCrashHelper("playable (trigger collection)");
        HashSet<TriggerAPI> playable = new HashSet<TriggerAPI>();
        for (TriggerAPI trigger2 : triggers) {
            this.setCrashHelper("playable (" + trigger2.getNameWithID() + ")");
            if (trigger2.isDisabled() || trigger2 instanceof BasicTrigger) continue;
            if (trigger2.query(this.context)) {
                if (trigger2.getState() != TriggerAPI.State.ACTIVE) {
                    trigger2.setState(TriggerAPI.State.PLAYABLE);
                }
                playable.add(trigger2);
                continue;
            }
            trigger2.setState(TriggerAPI.State.IDLE);
        }
        playable.removeIf(trigger -> !trigger.canActivate());
        return playable;
    }

    public Collection<TriggerAPI> getPriorityTriggers(Collection<TriggerAPI> triggers) {
        HashSet<TriggerAPI> priority = new HashSet<TriggerAPI>();
        int priorityVal = 0;
        for (TriggerAPI trigger : triggers) {
            int tPriority = trigger.getParameterAsInt("priority");
            if (priority.isEmpty()) {
                priority.add(trigger);
                priorityVal = tPriority;
                continue;
            }
            if (tPriority == priorityVal) {
                priority.add(trigger);
                continue;
            }
            if (ChannelHelper.getDebugBool("reverse_priority")) {
                if (tPriority >= priorityVal) continue;
                priority.clear();
                priority.add(trigger);
                priorityVal = tPriority;
                continue;
            }
            if (tPriority <= priorityVal) continue;
            priority.clear();
            priority.add(trigger);
            priorityVal = tPriority;
        }
        return priority;
    }

    @Nullable
    protected TriggerAPI getPriorityTrigger(Collection<TriggerAPI> registeredTriggers, boolean unpaused) {
        Collection<TriggerAPI> triggers = this.collectPlayableTriggers(registeredTriggers, unpaused);
        if (ChannelHelper.getDebugBool("independent_audio_pools")) {
            return TriggerHelper.getPriorityTrigger(triggers);
        }
        if (triggers.isEmpty()) {
            return null;
        }
        if ((triggers = this.getPriorityTriggers(triggers)).size() > 1) {
            return new TriggerMerged(this.channel, triggers);
        }
        Iterator<TriggerAPI> iterator = triggers.iterator();
        if (iterator.hasNext()) {
            TriggerAPI trigger = iterator.next();
            return trigger;
        }
        return null;
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    @Override
    protected String getSubTypeName() {
        return "Trigger";
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return TriggerSelector.class;
    }

    public boolean isClient() {
        return this.channel.isClientChannel();
    }

    @Override
    public boolean isResource() {
        return false;
    }

    public TriggerAPI queryOrIdle(@Nullable TriggerAPI priority, @Nullable TriggerAPI trigger, boolean unpaused) {
        if (Objects.nonNull(trigger)) {
            if (Objects.isNull(priority) && trigger.query(this.context)) {
                if (trigger.canActivate()) {
                    priority = trigger;
                } else {
                    trigger.setState(TriggerAPI.State.PLAYABLE);
                }
            } else if (!trigger.isDisabled()) {
                trigger.setState(TriggerAPI.State.IDLE);
            }
        }
        return priority;
    }

    public void select(boolean unpaused) {
        if (!this.setContext()) {
            return;
        }
        this.setCrashHelper("trigger selection");
        TriggerAPI priorityTrigger = null;
        ChannelData data = this.channel.getData();
        if (!this.context.hasPlayer()) {
            this.setCrashHelper("early triggers");
            if (this.isClient()) {
                this.setCrashHelper("loading trigger");
                priorityTrigger = this.queryOrIdle(null, data.getLoadingTrigger(), unpaused);
                this.setCrashHelper("menu trigger");
                priorityTrigger = this.queryOrIdle(priorityTrigger, data.getMenuTrigger(), unpaused);
            }
        } else {
            this.setCrashHelper("normal triggers");
            priorityTrigger = this.getPriorityTrigger(data.getTriggerEventMap().keySet(), unpaused);
        }
        this.setCrashHelper("generic trigger");
        priorityTrigger = this.queryOrIdle(priorityTrigger, data.getGenericTrigger(), unpaused);
        this.setActivePool(priorityTrigger instanceof BasicTrigger ? this.setBasicTrigger(priorityTrigger) : this.setActiveTrigger(priorityTrigger));
    }

    @Nullable
    protected AudioPool setActiveTrigger(TriggerAPI trigger) {
        if (this.channel.checkDeactivate(this.activeTrigger, trigger)) {
            if (Objects.nonNull(this.activeTrigger)) {
                this.channel.deactivate();
            }
            this.previousTrigger = this.activeTrigger;
            this.activeTrigger = trigger;
            if (Objects.nonNull(this.activeTrigger)) {
                this.logInfo("Activating trigger {}", this.activeTrigger);
                this.channel.activate();
            }
        }
        this.activeNonFadingTrigger = trigger;
        return Objects.nonNull(this.activeTrigger) ? this.activeTrigger.getAudioPool() : null;
    }

    protected void setActivePool(AudioPool pool) {
        this.previousPool = this.activePool;
        this.activePool = pool;
    }

    @Nullable
    protected AudioPool setBasicTrigger(TriggerAPI trigger) {
        return this.setActiveTrigger(trigger);
    }

    private boolean setContext() {
        if (Objects.isNull(this.context)) {
            if (!this.cleared) {
                this.clear();
                this.cleared = true;
            }
            return false;
        }
        this.cleared = false;
        this.context.cache();
        return true;
    }

    protected void setCrashHelper(@Nullable String status) {
        this.crashHelper = Objects.nonNull(status) ? status : "";
    }

    @Override
    public String toString() {
        return (this.isClient() ? "Client" : "Server") + " Trigger Selector [" + this.crashHelper + "]";
    }

    @Generated
    public TriggerContext getContext() {
        return this.context;
    }

    @Generated
    public TriggerAPI getActiveTrigger() {
        return this.activeTrigger;
    }

    @Generated
    public TriggerAPI getActiveNonFadingTrigger() {
        return this.activeNonFadingTrigger;
    }

    @Generated
    public TriggerAPI getPreviousTrigger() {
        return this.previousTrigger;
    }

    @Generated
    public AudioPool getActivePool() {
        return this.activePool;
    }

    @Generated
    public AudioPool getPreviousPool() {
        return this.previousPool;
    }

    @Generated
    public String getCrashHelper() {
        return this.crashHelper;
    }

    @Generated
    public boolean isCleared() {
        return this.cleared;
    }
}

