/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.basic.TriggerGeneric;
import mods.thecomputerizer.musictriggers.api.data.trigger.basic.TriggerLoading;
import mods.thecomputerizer.musictriggers.api.data.trigger.basic.TriggerMenu;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerAdvancement;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerBiome;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerBlockEntity;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerCommand;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerDifficulty;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerDimension;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerEffect;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerGUI;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerGamestage;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerHeight;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerInventory;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerLight;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerMob;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerMoon;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerPVP;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerRaid;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerRainIntensity;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerRiding;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerSeason;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerStatistic;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerStructure;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerTime;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerTornado;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerVictory;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerZones;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerAcidRain;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerAdventure;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerBlizzard;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerBloodmoon;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerBluemoon;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerCloudy;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerCreative;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerDead;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerDrowning;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerElytra;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerFishing;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerHarvestmoon;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerHome;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerHurricane;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerLightRain;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerLowHP;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerPet;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerRaining;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerSandstorm;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerSnowing;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerSpectator;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerStarShower;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerStorming;
import mods.thecomputerizer.musictriggers.api.data.trigger.simple.TriggerUnderwater;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.item.DiscBuilderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;

public class TriggerRegistry {
    private static final List<String> BLACKLISTED_NAMES = Arrays.asList("combination", "merged", "synced");
    private static final Map<String, Class<? extends TriggerAPI>> DEFAULT_TRIGGERS = TriggerRegistry.loadDefaultTriggers();
    private static final Map<String, Class<? extends TriggerAPI>> REGISTERED_TRIGGERS = new HashMap<String, Class<? extends TriggerAPI>>(DEFAULT_TRIGGERS);

    public static DiscBuilderAPI buildProperties(DiscBuilderAPI builder) {
        for (String name : REGISTERED_TRIGGERS.keySet()) {
            builder.addProperty(MTRef.res("trigger_" + name), (stack, world) -> {
                CompoundTagAPI tag = stack.getTag();
                String trigger = Objects.nonNull(tag) ? tag.getString("triggerID") : null;
                return Float.valueOf(Objects.nonNull(trigger) && name.equals(trigger) ? 1.0f : 0.0f);
            });
        }
        return builder;
    }

    @Nullable
    public static TriggerAPI getTriggerInstance(ChannelAPI channel, String name) {
        Class<? extends TriggerAPI> clazz = REGISTERED_TRIGGERS.get(name.toLowerCase());
        if (Objects.nonNull(clazz)) {
            Constructor constructor = ReflectionHelper.findConstructor(clazz, (Class[])new Class[]{ChannelAPI.class});
            if (Objects.nonNull(constructor)) {
                try {
                    return (TriggerAPI)constructor.newInstance(channel);
                }
                catch (ReflectiveOperationException ex) {
                    channel.logError("Unable to create new instance of trigger class `{}`!", clazz, ex);
                }
            }
        } else {
            channel.logError("Unable to locate trigger class of type {}!", name);
        }
        return null;
    }

    public static Set<String> getTriggerNames() {
        return new HashSet<String>(REGISTERED_TRIGGERS.keySet());
    }

    public static boolean isRegistred(String name) {
        return REGISTERED_TRIGGERS.containsKey(name);
    }

    private static Map<String, Class<? extends TriggerAPI>> loadDefaultTriggers() {
        HashMap<String, Class<? extends TriggerAPI>> map = new HashMap<String, Class<? extends TriggerAPI>>();
        map.put("acidrain", TriggerAcidRain.class);
        map.put("advancement", TriggerAdvancement.class);
        map.put("adventure", TriggerAdventure.class);
        map.put("biome", TriggerBiome.class);
        map.put("blizzard", TriggerBlizzard.class);
        map.put("blockentity", TriggerBlockEntity.class);
        map.put("bloodmoon", TriggerBloodmoon.class);
        map.put("bluemoon", TriggerBluemoon.class);
        map.put("cloudy", TriggerCloudy.class);
        map.put("command", TriggerCommand.class);
        map.put("creative", TriggerCreative.class);
        map.put("dead", TriggerDead.class);
        map.put("difficulty", TriggerDifficulty.class);
        map.put("dimension", TriggerDimension.class);
        map.put("drowning", TriggerDrowning.class);
        map.put("effect", TriggerEffect.class);
        map.put("elytra", TriggerElytra.class);
        map.put("fishing", TriggerFishing.class);
        map.put("gamestage", TriggerGamestage.class);
        map.put("generic", TriggerGeneric.class);
        map.put("gui", TriggerGUI.class);
        map.put("harvestmoon", TriggerHarvestmoon.class);
        map.put("height", TriggerHeight.class);
        map.put("home", TriggerHome.class);
        map.put("hurricane", TriggerHurricane.class);
        map.put("inventory", TriggerInventory.class);
        map.put("light", TriggerLight.class);
        map.put("lightrain", TriggerLightRain.class);
        map.put("loading", TriggerLoading.class);
        map.put("lowhp", TriggerLowHP.class);
        map.put("menu", TriggerMenu.class);
        map.put("mob", TriggerMob.class);
        map.put("moon", TriggerMoon.class);
        map.put("pet", TriggerPet.class);
        map.put("pvp", TriggerPVP.class);
        map.put("raid", TriggerRaid.class);
        map.put("raining", TriggerRaining.class);
        map.put("rainintensity", TriggerRainIntensity.class);
        map.put("riding", TriggerRiding.class);
        map.put("sandstorm", TriggerSandstorm.class);
        map.put("season", TriggerSeason.class);
        map.put("snowing", TriggerSnowing.class);
        map.put("spectator", TriggerSpectator.class);
        map.put("starshower", TriggerStarShower.class);
        map.put("statistic", TriggerStatistic.class);
        map.put("storming", TriggerStorming.class);
        map.put("structure", TriggerStructure.class);
        map.put("time", TriggerTime.class);
        map.put("tornado", TriggerTornado.class);
        map.put("underwater", TriggerUnderwater.class);
        map.put("victory", TriggerVictory.class);
        map.put("zones", TriggerZones.class);
        return map;
    }

    public static void registerTrigger(String name, Class<? extends TriggerAPI> clazz) {
        TriggerRegistry.registerTrigger(name, clazz, false);
    }

    public static void registerTrigger(String name, Class<? extends TriggerAPI> clazz, boolean overrideDefault) {
        if (BLACKLISTED_NAMES.contains(name)) {
            ChannelHelper.logGlobalError("Tried to register trigger with blacklisted name `{}`!", name);
        } else if (REGISTERED_TRIGGERS.containsKey(name)) {
            if (overrideDefault) {
                REGISTERED_TRIGGERS.put(name, clazz);
            } else {
                ChannelHelper.logGlobalWarn("There is already a trigger with the name {} registered to `{}`! If you know what you are doing and want to override it anyways make sure to call registerTrigger with overrideDefault set to true", name, REGISTERED_TRIGGERS.get(name));
            }
        } else {
            REGISTERED_TRIGGERS.put(name, clazz);
        }
    }
}

