/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelData;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerCombination;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerRegistry;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class TriggerHelper {
    public static Comparator<TriggerAPI> PRIORITY_COMPARATOR = Comparator.comparingInt(trigger -> trigger.getParameterAsInt("priority"));

    private static boolean checkVersion(@Nullable TriggerAPI trigger) {
        return Objects.nonNull(trigger);
    }

    public static TriggerAPI decodeTrigger(ChannelAPI channel, ByteBuf buf) {
        return TriggerHelper.decodeTrigger(channel, NetworkHelper.readString((ByteBuf)buf), NetworkHelper.readString((ByteBuf)buf));
    }

    public static TriggerAPI decodeTrigger(@Nullable ChannelAPI channel, String name, String id) {
        if (Objects.nonNull(channel)) {
            String nameWithID;
            channel.logDebug("Decoding trigger from {}-{}", name, id);
            ChannelData data = channel.getData();
            switch (nameWithID = Misc.equalsAny((Object)id, (Object[])new String[]{null, "null", "not_set"}) ? name : name + "-" + id) {
                case "generic": {
                    return data.getGenericTrigger();
                }
                case "loading": {
                    return data.getLoadingTrigger();
                }
                case "menu": {
                    return data.getMenuTrigger();
                }
            }
            for (TriggerAPI trigger : data.getTriggers()) {
                if (!trigger.getNameWithID().equals(nameWithID)) continue;
                return trigger;
            }
        }
        return null;
    }

    public static TriggerAPI decodeTrigger(ChannelAPI channel, CompoundTagAPI<?> tag) {
        TriggerAPI decoded = null;
        if (tag.contains("name")) {
            String name = tag.getString("name");
            if ("combination".equals(name)) {
                ArrayList<TriggerAPI> triggers = new ArrayList<TriggerAPI>();
                tag.getListTag("triggers").forEach(based -> {
                    TriggerAPI trigger = TriggerHelper.decodeTrigger(channel, based.asCompoundTag());
                    if (Objects.nonNull(trigger)) {
                        triggers.add(trigger);
                    }
                });
                if (!triggers.isEmpty()) {
                    for (TriggerAPI trigger : channel.getData().getTriggerEventMap().keySet()) {
                        if (!trigger.matches(triggers)) continue;
                        decoded = trigger;
                        break;
                    }
                }
            } else {
                decoded = TriggerHelper.decodeTrigger(channel, name, tag.contains("id") ? tag.getString("id") : null);
            }
        }
        return decoded;
    }

    @Nullable
    public static TriggerAPI findTrigger(ChannelHelper helper, @Nullable ChannelAPI channel, String name) {
        if (Objects.nonNull(channel)) {
            for (TriggerAPI trigger : channel.getData().getTriggers()) {
                if (!trigger.getNameWithID().equals(name)) continue;
                return trigger;
            }
            return null;
        }
        return TriggerHelper.findTrigger(helper, name);
    }

    @Nullable
    public static TriggerAPI findTrigger(ChannelHelper helper, String name) {
        for (ChannelAPI channel : helper.getChannels().values()) {
            TriggerAPI trigger = TriggerHelper.findTrigger(helper, channel, name);
            if (!Objects.nonNull(trigger)) continue;
            return trigger;
        }
        return null;
    }

    public static boolean findTriggers(boolean implyMissing, @Nullable ChannelAPI channel, Collection<TriggerAPI> triggers, Collection<?> names) {
        if (Objects.isNull(channel) || Objects.isNull(triggers)) {
            return false;
        }
        if (Objects.isNull(names) || names.isEmpty()) {
            return true;
        }
        for (Object name : names) {
            String nameStr = name.toString();
            int index = nameStr.indexOf(45);
            nameStr = index <= 0 ? nameStr.toLowerCase() : nameStr.substring(0, index).toLowerCase() + nameStr.substring(index);
            TriggerAPI trigger = TriggerHelper.findTrigger(channel.getHelper(), channel, nameStr);
            if (Objects.isNull(trigger) && implyMissing && channel.implyTrigger(nameStr)) {
                trigger = TriggerHelper.findTrigger(channel.getHelper(), channel, nameStr);
            }
            if (Objects.isNull(trigger)) {
                channel.logWarn("Unknown trigger `{}` in triggers array!", nameStr);
                return false;
            }
            triggers.add(trigger);
        }
        return true;
    }

    public static TriggerCombination getCombination(ChannelAPI channel, Collection<TriggerAPI> triggers) {
        TriggerCombination combo = new TriggerCombination(channel);
        for (TriggerAPI child : triggers) {
            combo.addChild(child);
        }
        return combo;
    }

    @Nullable
    public static TriggerAPI getPriorityTrigger(@Nullable Collection<TriggerAPI> triggers) {
        if (Objects.isNull(triggers) || triggers.isEmpty()) {
            return null;
        }
        return ChannelHelper.getDebugBool("reverse_priority") ? Collections.min(triggers, PRIORITY_COMPARATOR) : Collections.max(triggers, PRIORITY_COMPARATOR);
    }

    public static boolean matchesAll(Collection<TriggerAPI> triggers, Collection<TriggerAPI> others) {
        if (triggers.size() != others.size()) {
            return false;
        }
        for (TriggerAPI trigger : triggers) {
            if (TriggerHelper.matchesAny(others, trigger)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesAny(Collection<TriggerAPI> triggers, Collection<TriggerAPI> others) {
        for (TriggerAPI other : others) {
            if (!TriggerHelper.matchesAny(triggers, other)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesAny(Collection<TriggerAPI> triggers, TriggerAPI other) {
        for (TriggerAPI trigger : triggers) {
            if (!trigger.matches(other)) continue;
            return true;
        }
        return false;
    }

    public static void parseTriggers(ChannelAPI channel, Collection<TriggerAPI> triggers, @Nullable Toml table) {
        if (Objects.isNull(table)) {
            return;
        }
        for (Toml triggerTable : table.getAllTables()) {
            if (triggerTable.getName().equals("universal")) {
                UniversalParameters universal = channel.getData().getUniversals(TriggerAPI.class);
                if (Objects.isNull(universal) || !universal.parse(triggerTable)) {
                    channel.logError("Failed to parse universal triggers", new Object[0]);
                    continue;
                }
                channel.logInfo("Intialized universal trigger data", new Object[0]);
                continue;
            }
            TriggerAPI trigger = TriggerRegistry.getTriggerInstance(channel, triggerTable.getName());
            if (!TriggerHelper.checkVersion(trigger) || !trigger.parse(triggerTable)) continue;
            triggers.add(trigger);
        }
    }
}

