/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerSynced;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;

public class TriggerCombination
extends TriggerAPI {
    private final Collection<TriggerAPI> triggers = new HashSet<TriggerAPI>();

    public static TriggerCombination make(ChannelAPI channel, Collection<TriggerAPI> triggers) {
        TriggerCombination combo = new TriggerCombination(channel);
        for (TriggerAPI trigger : triggers) {
            combo.addChild(trigger);
        }
        return combo;
    }

    protected TriggerCombination(ChannelAPI channel) {
        super(channel, "combination");
    }

    public void addChild(TriggerAPI trigger) {
        this.triggers.add(trigger);
        this.setParentStatus(trigger, false);
        this.recalculateParameters();
    }

    @Override
    public void afterSync(Map<TriggerAPI, TriggerSynced> syncedMap) {
        HashSet<TriggerAPI> replaceThese = new HashSet<TriggerAPI>();
        for (TriggerAPI trigger : this.triggers) {
            if (!syncedMap.containsKey(trigger)) continue;
            replaceThese.add(trigger);
        }
        if (!replaceThese.isEmpty()) {
            this.triggers.removeIf(replaceThese::contains);
            for (TriggerAPI trigger : replaceThese) {
                this.triggers.add(syncedMap.get(trigger));
            }
            this.logInfo("Replaced synced triggers {}", replaceThese);
        }
    }

    @Override
    public boolean canActivate() {
        if (!this.hasNonEmptyAudioPool() || this.triggers.isEmpty()) {
            return false;
        }
        for (TriggerAPI trigger : this.triggers) {
            if (trigger.canActivate(false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkSidedContext(TriggerContext context) {
        for (TriggerAPI trigger : this.triggers) {
            if (trigger.isPlayableContext(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        super.close();
        this.triggers.clear();
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        NetworkHelper.writeCollection((ByteBuf)buf, this.triggers, trigger -> trigger.encode(buf));
    }

    @Override
    public String getName() {
        StringJoiner joiner = new StringJoiner("+");
        for (TriggerAPI trigger : this.triggers) {
            joiner.add(trigger.getNameWithID());
        }
        return this.triggers.size() == 1 ? joiner.toString() : "Combination = " + joiner;
    }

    @Override
    public Parameter<?> getParameter(String name) {
        TriggerAPI priority = TriggerHelper.getPriorityTrigger(this.triggers);
        return Objects.nonNull(priority) ? priority.getParameter(name) : super.getParameter(name);
    }

    public boolean isContained(TriggerAPI trigger) {
        return trigger.matches(this.triggers);
    }

    @Override
    public boolean isDisabled() {
        for (TriggerAPI trigger : this.triggers) {
            if (!trigger.isDisabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initExtraParameters(Map<String, Parameter<?>> map) {
    }

    @Override
    public boolean isPlayableContext(TriggerContext ctx) {
        return false;
    }

    @Override
    public boolean isContained(Collection<TriggerAPI> triggers) {
        return TriggerHelper.matchesAny(this.triggers, triggers);
    }

    @Override
    public boolean matches(Collection<TriggerAPI> triggers) {
        return TriggerHelper.matchesAll(this.triggers, triggers);
    }

    @Override
    public boolean matches(TriggerAPI trigger) {
        return trigger instanceof TriggerCombination && this.matches(((TriggerCombination)trigger).triggers);
    }

    @Override
    public boolean query(TriggerContext context) {
        return !this.triggers.isEmpty() && super.query(context);
    }

    protected void recalculateParameters() {
        TriggerAPI reference = TriggerHelper.getPriorityTrigger(this.triggers);
        if (Objects.nonNull(reference)) {
            this.inheritParameters(reference);
            this.recalculateTimers(reference);
        }
    }

    protected void recalculateTimers(TriggerAPI reference) {
        for (String name : reference.getTimedParameterNames()) {
            TriggerAPI.State timeState = this.getParameterTimeState(name);
            if (timeState == TriggerAPI.State.DISABLED) continue;
            this.addTimedParameter(name, timeState, this.getParameter(name));
        }
    }

    protected void setParentStatus(TriggerAPI trigger, boolean removal) {
        Set<TriggerCombination> parents = trigger.getParents();
        if (removal) {
            parents.remove(this);
        } else {
            parents.add(this);
        }
    }

    @Override
    public void setUniversals(UniversalParameters universals) {
        super.setUniversals(universals);
        for (TriggerAPI trigger : this.triggers) {
            trigger.setUniversals(universals);
        }
    }

    @Override
    public String toString() {
        return this.getSubTypeName() + "[" + this.getName() + "]";
    }

    @Override
    public boolean verifyRequiredParameters() {
        for (TriggerAPI trigger : this.triggers) {
            if (trigger.verifyRequiredParameters()) continue;
            this.logError("Unable to construct trigger combination due to 1 or more triggers failing verification!", new Object[0]);
            this.setParentStatus(trigger, true);
            return false;
        }
        return true;
    }

    @Override
    public void write(CompoundTagAPI<?> tag) {
        tag.putString("name", "combination");
        ListTagAPI triggersTag = TagHelper.makeListTag();
        for (TriggerAPI trigger : this.triggers) {
            CompoundTagAPI triggerTag = TagHelper.makeCompoundTag();
            trigger.write(triggerTag);
            triggersTag.addTag((BaseTagAPI)triggerTag);
        }
        tag.putTag("triggers", (BaseTagAPI)triggersTag);
    }
}

