/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.WrapperLink;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelEventHandler;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelSyncable;
import mods.thecomputerizer.musictriggers.api.data.nbt.NBTLoadable;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.ResourceContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerCombination;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerMerged;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerSynced;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public abstract class TriggerAPI
extends ChannelElement
implements ChannelSyncable,
NBTLoadable {
    protected static final Map<TriggerAPI, Map<String, Timer>> TIMER_MAP = new HashMap<TriggerAPI, Map<String, Timer>>();
    private final Set<TriggerCombination> parents = new HashSet<TriggerCombination>();
    protected final Set<Link> links = new HashSet<Link>();
    protected Link activeLink;
    private ResourceContext resourceCtx;
    private State state = State.IDLE;
    protected int tracksPlayed;
    protected TriggerSynced syncedWrapper;

    protected TriggerAPI(ChannelAPI channel, String name) {
        super(channel, name);
    }

    @Override
    public void activate() {
        this.setState(State.ACTIVE);
        this.setTimer("ticks_before_audio", State.ACTIVE);
    }

    protected void addTimedParameter(String name, State state, Parameter<?> parameter) {
        if (Objects.nonNull(parameter)) {
            TIMER_MAP.putIfAbsent(this, new HashMap());
            TIMER_MAP.get(this).put(name, new Timer(this, name, state));
        }
    }

    public boolean canActivate() {
        return this.canActivate(true);
    }

    protected boolean canActivate(boolean checkAudioPool) {
        State state = this.getSyncedState();
        return state.activatable && this.hasNoTime("active_cooldown") && this.hasNoTime("ticks_before_active") && (!checkAudioPool || this.hasNonEmptyAudioPool());
    }

    public void afterSync(Map<TriggerAPI, TriggerSynced> syncedMap) {
        if (syncedMap.containsKey(this)) {
            this.setSyncedWrapper(syncedMap.get(this));
        }
    }

    protected boolean canPersist() {
        return this.hasTime("persistence") && (this.getState() == State.ACTIVE || this.getState() == State.PLAYABLE && this.getParameterAsBoolean("passive_persistence"));
    }

    public boolean canPlayAudio() {
        if (this.tracksPlayed == 0) {
            return this.hasNoTime("ticks_before_audio");
        }
        int maxTracks = this.getParameterAsInt("max_tracks");
        return (maxTracks <= 0 || this.tracksPlayed < maxTracks) && this.hasNoTime("ticks_between_audio");
    }

    public boolean checkPaused(boolean unpaused) {
        return unpaused || this.getParameterAsBoolean("play_when_paused");
    }

    protected boolean checkSidedContext(TriggerContext context) {
        return this.isSynced() ? context.getSyncedContext(this) : this.isPlayableContext(context);
    }

    protected void clearTimers(State state) {
        this.consumeTimers(timer -> timer.clear(state));
    }

    @Override
    public void close() {
        if (TIMER_MAP.containsKey(this)) {
            TIMER_MAP.get(this).clear();
            TIMER_MAP.remove(this);
        }
        this.parents.clear();
        this.links.clear();
        this.resourceCtx = null;
        this.state = State.DISABLED;
        this.tracksPlayed = 0;
    }

    protected void consumeTimers(Consumer<Timer> consumer) {
        if (TIMER_MAP.containsKey(this)) {
            TIMER_MAP.get(this).values().forEach(consumer);
        }
    }

    @Override
    public void deactivate() {
        this.clearTimers(State.ACTIVE);
        this.setTimer("active_cooldown", State.PLAYABLE);
        this.tracksPlayed = 0;
        if (!this.isDisabled()) {
            this.setState(this.query(this.channel.getSelector().context) ? State.PLAYABLE : State.IDLE);
        }
    }

    @Override
    public void encode(ByteBuf buf) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.getName());
        NetworkHelper.writeString((ByteBuf)buf, (String)this.getIdentifier());
    }

    public boolean equals(Object other) {
        return other instanceof TriggerAPI && ((TriggerAPI)other).getNameWithID().equals(this.getNameWithID());
    }

    @Nullable
    public AudioPool getAudioPool() {
        Collection<ChannelEventHandler> handlers = this.channel.getData().getTriggerEventMap().get(this);
        if (Objects.isNull(handlers)) {
            return null;
        }
        for (ChannelEventHandler handler : handlers) {
            if (!(handler instanceof AudioPool)) continue;
            return (AudioPool)handler;
        }
        return null;
    }

    @Override
    public Collection<DataLink> getChildWrappers(MTScreenInfo parent) {
        WrapperLink links = new WrapperLink(this.links);
        links.setType(parent.next("links", links));
        return Collections.singletonList(links);
    }

    public String getIdentifier() {
        return this.hasParameter("identifier") ? this.getParameterAsString("identifier") : "not_set";
    }

    public String getNameWithID() {
        return this.getName();
    }

    protected State getParameterTimeState(String name) {
        return Misc.equalsAny((Object)name, (Object[])new String[]{"persistence", "ticks_before_audio", "ticks_between_audio"}) ? State.ACTIVE : (Misc.equalsAny((Object)name, (Object[])new String[]{"active_cooldown", "ticks_before_active"}) ? State.PLAYABLE : State.DISABLED);
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return MTDataRef.findTriggerRef(this.name);
    }

    public List<String> getRequiredMods() {
        return Collections.emptyList();
    }

    public State getSyncedState() {
        return Objects.nonNull(this.syncedWrapper) ? this.syncedWrapper.getState() : this.getState();
    }

    protected Set<String> getTimedParameterNames() {
        return TIMER_MAP.getOrDefault(this, Collections.emptyMap()).keySet();
    }

    @Nullable
    protected Timer getTimer(String name) {
        return TIMER_MAP.containsKey(this) ? TIMER_MAP.get(this).get(name) : null;
    }

    public Class<? extends ChannelElement> getTypeClass() {
        return TriggerAPI.class;
    }

    @Override
    protected String getSubTypeName() {
        return "Trigger";
    }

    @Override
    public boolean hasDataToSave() {
        AudioPool pool = this.getAudioPool();
        return Objects.nonNull(pool) && pool.hasDataToSave();
    }

    public boolean hasNonEmptyAudioPool() {
        AudioPool pool = this.getAudioPool();
        return Objects.nonNull(pool) && pool.hasAudio();
    }

    public boolean hasNoTime(String name) {
        Timer timer = this.getTimer(name);
        return Objects.isNull(timer) || !timer.hasTime();
    }

    public boolean hasTime(String name) {
        Timer timer = this.getTimer(name);
        return Objects.nonNull(timer) && timer.hasTime();
    }

    public boolean imply(String id) {
        this.setExistingParameterValue("identifier", id);
        return this.verifyRequiredParameters();
    }

    @Override
    protected void initExtraParameters(Map<String, Parameter<?>> parameters) {
        for (Map.Entry<String, Parameter<?>> entry : parameters.entrySet()) {
            State timeState = this.getParameterTimeState(entry.getKey());
            if (timeState == State.DISABLED) continue;
            this.addTimedParameter(entry.getKey(), timeState, entry.getValue());
        }
    }

    public boolean isContained(Collection<TriggerAPI> triggers) {
        return TriggerHelper.matchesAny(triggers, this);
    }

    public boolean isDisabled() {
        return this.getState() == State.DISABLED;
    }

    public boolean isFirstTrack() {
        return this.tracksPlayed == 1;
    }

    public abstract boolean isPlayableContext(TriggerContext var1);

    @Override
    public boolean isResource() {
        return false;
    }

    protected boolean isServer() {
        return false;
    }

    public boolean isSynced() {
        if (this.isServer()) {
            return this.channel.isClientChannel();
        }
        return !this.channel.isClientChannel();
    }

    public boolean matches(Collection<TriggerAPI> triggers) {
        return triggers.size() == 1 && this.isContained(triggers);
    }

    public boolean matches(TriggerAPI trigger) {
        return this.equals(trigger);
    }

    @Override
    public void onConnected(CompoundTagAPI<?> worldData) {
        AudioPool pool = this.getAudioPool();
        if (Objects.nonNull(pool)) {
            pool.onConnected(worldData);
        }
    }

    public void onDisconnected() {
        AudioPool pool = this.getAudioPool();
        if (Objects.nonNull(pool)) {
            pool.onDisconnected();
        }
    }

    @Override
    public void onLoaded(CompoundTagAPI<?> globalData) {
        AudioPool pool = this.getAudioPool();
        if (Objects.nonNull(pool)) {
            pool.onLoaded(globalData);
        }
    }

    @Override
    public boolean parse(Toml table) {
        if (super.parse(table)) {
            if (table.hasTable("link")) {
                for (Toml linkTable : table.getTableArray("link")) {
                    Link link = new Link(this, linkTable);
                    if (link.valid) {
                        this.logDebug("Adding link to triggers Channel[{}]: {}", link.targetChannel.getName(), link.linkedTriggers);
                        this.links.add(link);
                        continue;
                    }
                    this.logDebug("Skipping invalid link", new Object[0]);
                }
            }
            this.successfullyParsed();
            this.logInfo("Successfully parsed", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void play(boolean unpaused) {
        ++this.tracksPlayed;
    }

    @Override
    public void playable() {
        this.setTimer("ticks_before_active", State.PLAYABLE);
    }

    public boolean query(TriggerContext context) {
        if (this.isDisabled()) {
            return false;
        }
        boolean playableCtx = this.checkSidedContext(context);
        boolean not = this.getParameterAsBoolean("not");
        if (playableCtx && !not || !playableCtx && not) {
            this.setTimer("persistence", State.ACTIVE);
            return true;
        }
        return this.canPersist();
    }

    @Override
    public void saveGlobalTo(CompoundTagAPI<?> globalData) {
        this.savePersistentData(globalData, true);
    }

    protected void savePersistentData(CompoundTagAPI<?> data, boolean global) {
        boolean written = false;
        AudioPool pool = this.getAudioPool();
        if (Objects.nonNull(pool) && !global) {
            pool.saveWorldTo(data);
            written = true;
        }
        if (written) {
            this.write(data);
        }
    }

    @Override
    public void saveWorldTo(CompoundTagAPI<?> worldData) {
        this.savePersistentData(worldData, false);
    }

    protected <V> void setExistingParameterValue(String name, V value) {
        Parameter<?> parameter = this.getParameter(name);
        if (Objects.nonNull(parameter)) {
            parameter.setValue(value);
        }
    }

    public void setState(State state) {
        if (!this.isSynced() && this.state != state) {
            this.logInfo("Setting state from {} to {}", new Object[]{this.state, state});
            switch (this.state.ordinal()) {
                case 0: 
                case 3: {
                    this.setStateWithHandle(state, ChannelEventHandler::unplayable, State.DISABLED, State.IDLE);
                    break;
                }
                case 1: 
                case 2: {
                    this.setStateWithHandle(state, ChannelEventHandler::playable, State.PLAYABLE, State.ACTIVE);
                }
            }
        }
    }

    private void setStateWithHandle(State state, Consumer<ChannelEventHandler> handle, State ... validStates) {
        boolean shouldHandle = false;
        for (State validState : validStates) {
            if (state != validState) continue;
            shouldHandle = true;
            break;
        }
        if (shouldHandle) {
            for (ChannelEventHandler handler : this.channel.getData().getEventHandlers(this)) {
                handle.accept(handler);
            }
        }
        this.state = state;
        this.channel.getSync().queueTriggerSync(this);
    }

    protected void setSyncedWrapper(TriggerSynced synced) {
        if (this instanceof TriggerCombination || this instanceof TriggerMerged || this instanceof TriggerSynced) {
            return;
        }
        this.syncedWrapper = synced;
    }

    protected void setTimer(String name, State state) {
        Timer timer;
        Timer timer2 = timer = TIMER_MAP.containsKey(this) ? TIMER_MAP.get(this).get(name) : null;
        if (Objects.nonNull(timer)) {
            timer.set(state);
        }
    }

    public void setToggle(boolean on) {
        State state = this.getState();
        this.logInfo("Toggling from {} to {}", state != State.DISABLED, on);
        if (state == State.DISABLED && on) {
            this.setState(State.IDLE);
        } else if (state != State.DISABLED && !on) {
            this.setState(State.DISABLED);
        }
    }

    public void switchToggle() {
        State state = this.getState();
        this.logInfo("Toggling from {} to {}", state != State.DISABLED, state == State.DISABLED);
        if (state == State.DISABLED) {
            this.setState(State.IDLE);
        } else {
            this.setState(State.DISABLED);
        }
    }

    @Override
    public void stopped() {
        this.setTimer("ticks_between_audio", State.ACTIVE);
    }

    public void successfullyParsed() {
        if (this.hasParameter("resource_name")) {
            List<String> resourceName = this.getParameterAsList("resource_name");
            List<String> displayeName = this.getParameterAsList("display_name");
            String resourceMatcher = this.getParameterAsString("resource_matcher");
            String displayMatcher = this.getParameterAsString("display_matcher");
            this.resourceCtx = new ResourceContext(resourceName, displayeName, resourceMatcher, displayMatcher);
        } else {
            this.resourceCtx = null;
        }
        this.setState(this.getParameterAsBoolean("start_as_disabled") ? State.DISABLED : State.IDLE);
    }

    @Override
    public void tickActive(boolean unpaused) {
        this.tickTimers(State.ACTIVE);
    }

    @Override
    public void tickPlayable(boolean unpaused) {
        this.tickTimers(State.PLAYABLE);
    }

    protected void tickTimers(State state) {
        this.consumeTimers(timer -> timer.tick(state));
    }

    @Override
    public String toString() {
        return this.getSubTypeName() + "[" + this.getNameWithID() + "]";
    }

    @Override
    protected Toml toTomlExtra(Toml toml) {
        toml = super.toTomlExtra(toml);
        for (Link link : this.links) {
            toml.addTable("link", link.toToml());
        }
        return toml;
    }

    @Override
    public void unplayable() {
        this.clearTimers(State.PLAYABLE);
    }

    public void write(CompoundTagAPI<?> tag) {
        tag.putString("name", this.getName());
        if (this instanceof HolderTrigger) {
            tag.putString("id", this.getIdentifier());
        }
    }

    @Generated
    public Set<TriggerCombination> getParents() {
        return this.parents;
    }

    @Generated
    public Set<Link> getLinks() {
        return this.links;
    }

    @Generated
    public Link getActiveLink() {
        return this.activeLink;
    }

    @Generated
    public ResourceContext getResourceCtx() {
        return this.resourceCtx;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public int getTracksPlayed() {
        return this.tracksPlayed;
    }

    @Generated
    public TriggerSynced getSyncedWrapper() {
        return this.syncedWrapper;
    }

    @Generated
    public void setActiveLink(Link activeLink) {
        this.activeLink = activeLink;
    }

    public static enum State {
        ACTIVE(true, true),
        DISABLED(false, false),
        IDLE(true, false),
        PLAYABLE(true, true);

        private final boolean activatable;
        private final boolean playable;

        private State(boolean activatable, boolean playable) {
            this.activatable = activatable;
            this.playable = playable;
        }

        public String toString() {
            return this.name();
        }

        @Generated
        public boolean isActivatable() {
            return this.activatable;
        }

        @Generated
        public boolean isPlayable() {
            return this.playable;
        }
    }

    protected static class Timer {
        private final TriggerAPI parent;
        private final String name;
        private final State state;
        private final AtomicInteger counter;

        protected Timer(TriggerAPI parent, String name, State state) {
            this.parent = parent;
            this.name = name;
            this.state = state;
            this.counter = new AtomicInteger();
        }

        protected void clear(State state) {
            if (this.state == state) {
                this.counter.set(0);
            }
        }

        protected boolean hasTime() {
            return this.counter.get() > 0;
        }

        protected void set(State state) {
            if (this.state == state) {
                this.counter.set(this.parent.getParameterAsInt(this.name));
            }
        }

        protected void tick(State state) {
            if (this.state == state && this.counter.get() > 0) {
                this.counter.decrementAndGet();
            }
        }
    }

    public static class Link
    extends ChannelElement {
        private final TriggerAPI parent;
        private final ChannelAPI targetChannel;
        private final boolean inheritor;
        private final boolean resumeAfterLink;
        private final List<TriggerAPI> linkedTriggers;
        private final List<TriggerAPI> requiredTriggers;
        private final boolean valid;
        private long snapshotInherit;
        private long snapshotLink;

        public static Link addToGui(MTScreenInfo info) {
            TriggerAPI parent = (TriggerAPI)((ParameterLink)info.getLink()).getWrapper();
            Toml table = Toml.getEmpty();
            table.addEntry("target_channel", (Object)parent.channel.getName());
            return new Link(parent, table);
        }

        protected Link(TriggerAPI parent, Toml table) {
            super(parent.channel, parent.getNameWithID() + "-link");
            this.parent = parent;
            this.linkedTriggers = new ArrayList<TriggerAPI>();
            this.requiredTriggers = new ArrayList<TriggerAPI>();
            if (!this.parse(table)) {
                this.logError("Failed to parse", new Object[0]);
                this.targetChannel = null;
                this.inheritor = false;
                this.resumeAfterLink = false;
                this.valid = false;
            } else {
                String channelName = this.getParameterAsString("target_channel");
                ChannelAPI channel = this.channel.getHelper().findChannel(this, channelName);
                if (Objects.isNull(channel)) {
                    this.logWarn("Could not find target_channel {}! Falling back to current {}", channelName, this.channel.getName());
                    this.targetChannel = this.channel;
                } else {
                    this.targetChannel = channel;
                }
                this.inheritor = this.getParameterAsBoolean("inherit_time");
                this.resumeAfterLink = this.getParameterAsBoolean("resume_after_link");
                if (!this.parseTriggers(this.targetChannel, this.linkedTriggers, "linked_triggers")) {
                    this.logWarn("Failed to parse linked triggers from channel {}", channelName);
                    this.valid = false;
                } else if (!this.parseTriggers(this.targetChannel, this.requiredTriggers, "required_triggers")) {
                    this.logWarn("Failed to parse required triggers", new Object[0]);
                    this.valid = false;
                } else {
                    this.requiredTriggers.add(this.parent);
                    this.valid = true;
                }
            }
        }

        @Override
        public void activate() {
            if (this.channel.areTheseActive(this.requiredTriggers)) {
                this.snapshotLink = this.channel.getPlayingSongTime();
                this.targetChannel.getActiveTrigger().activeLink = this;
                this.channel.disable(this);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public MTDataRef.TableRef getReferenceData() {
            return MTDataRef.LINK;
        }

        @Override
        protected String getSubTypeName() {
            return "Link";
        }

        @Override
        public Class<? extends ParameterWrapper> getTypeClass() {
            return Link.class;
        }

        @Override
        public boolean isResource() {
            return false;
        }

        public void setupTarget() {
            this.targetChannel.getData().addActiveTriggers(this, this.linkedTriggers, true);
        }

        public void unlink() {
            this.channel.enable();
        }

        @Generated
        public TriggerAPI getParent() {
            return this.parent;
        }

        @Generated
        public ChannelAPI getTargetChannel() {
            return this.targetChannel;
        }

        @Generated
        public boolean isInheritor() {
            return this.inheritor;
        }

        @Generated
        public boolean isResumeAfterLink() {
            return this.resumeAfterLink;
        }

        @Generated
        public List<TriggerAPI> getLinkedTriggers() {
            return this.linkedTriggers;
        }

        @Generated
        public List<TriggerAPI> getRequiredTriggers() {
            return this.requiredTriggers;
        }

        @Generated
        public boolean isValid() {
            return this.valid;
        }

        @Generated
        public long getSnapshotInherit() {
            return this.snapshotInherit;
        }

        @Generated
        public long getSnapshotLink() {
            return this.snapshotLink;
        }

        @Generated
        public void setSnapshotInherit(long snapshotInherit) {
            this.snapshotInherit = snapshotInherit;
        }

        @Generated
        public void setSnapshotLink(long snapshotLink) {
            this.snapshotLink = snapshotLink;
        }
    }
}

