/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import lombok.Generated;

public class ResourceContext {
    private final boolean defaultDisplay;
    private final boolean defaultResource;
    private final List<String> displayMatchers;
    private final List<String> resourcesMatchers;
    private final BiFunction<String, List<String>, Boolean> displayMatchFunc;
    private final BiFunction<String, List<String>, Boolean> resourceMatchFunc;
    boolean anyReturns = true;

    public ResourceContext(List<String> resourcesMatchers, List<String> displayMatchers, String resourceMatchType, String displayMatchType) {
        this.displayMatchers = displayMatchers.isEmpty() ? Collections.singletonList("any") : displayMatchers;
        this.defaultDisplay = displayMatchers.contains("any");
        this.resourcesMatchers = resourcesMatchers.isEmpty() ? Collections.singletonList("any") : resourcesMatchers;
        this.defaultResource = resourcesMatchers.contains("any");
        this.displayMatchFunc = this.getMatchFunc(displayMatchType);
        this.resourceMatchFunc = this.getMatchFunc(resourceMatchType);
    }

    protected BiFunction<String, List<String>, Boolean> getMatchFunc(String matcherType) {
        switch (matcherType.toLowerCase()) {
            case "exact": {
                return (id, matchThese) -> {
                    if (Objects.isNull(id)) {
                        return matchThese.contains(null) || matchThese.contains("");
                    }
                    if (matchThese.contains("any")) {
                        return this.anyReturns;
                    }
                    for (String matchThis : matchThese) {
                        if (!id.equals(matchThis)) continue;
                        return true;
                    }
                    return false;
                };
            }
            case "partial": {
                return (id, matchThese) -> {
                    if (Objects.isNull(id)) {
                        return matchThese.contains(null) || matchThese.contains("");
                    }
                    if (matchThese.contains("any")) {
                        return this.anyReturns;
                    }
                    for (String matchThis : matchThese) {
                        if (!id.contains(matchThis)) continue;
                        return true;
                    }
                    return false;
                };
            }
            case "regex": {
                return (id, matchThese) -> {
                    if (Objects.isNull(id)) {
                        return matchThese.contains(null) || matchThese.contains("");
                    }
                    if (matchThese.contains("any")) {
                        return this.anyReturns;
                    }
                    for (String matchThis : matchThese) {
                        if (!id.matches(matchThis)) continue;
                        return true;
                    }
                    return false;
                };
            }
        }
        return (id, matchThese) -> false;
    }

    public boolean checkDisplayMatch(@Nullable String display) {
        return this.displayMatchFunc.apply(display, this.displayMatchers);
    }

    public boolean checkMatch(@Nullable String id, @Nullable String display) {
        boolean checkDisplay = this.shouldCheck(display, id, this.defaultDisplay, this.defaultResource);
        boolean checkResource = this.shouldCheck(id, display, this.defaultResource, this.defaultDisplay);
        return this.checkMatch(id, display, checkDisplay, checkResource);
    }

    private boolean checkMatch(@Nullable String id, @Nullable String display, boolean checkDisplay, boolean checkResource) {
        return checkDisplay && this.checkDisplayMatch(display) || checkResource && this.checkResourceMatch(id);
    }

    public boolean checkResourceMatch(@Nullable String id) {
        return this.resourceMatchFunc.apply(id, this.resourcesMatchers);
    }

    private boolean shouldCheck(@Nullable String main, @Nullable String other, boolean defaultMain, boolean defaultOther) {
        return Objects.isNull(other) || defaultOther || Objects.nonNull(main) && !defaultMain;
    }

    @Generated
    public List<String> getDisplayMatchers() {
        return this.displayMatchers;
    }

    @Generated
    public List<String> getResourcesMatchers() {
        return this.resourcesMatchers;
    }

    @Generated
    public void setAnyReturns(boolean anyReturns) {
        this.anyReturns = anyReturns;
    }
}

