/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.client.gui.MTScreenInfo;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.DataLink;
import mods.thecomputerizer.musictriggers.api.client.gui.parameters.ParameterLink;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.log.LoggableAPI;
import mods.thecomputerizer.musictriggers.api.data.log.MTLogger;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterList;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterString;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterBool;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterNumber;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.Toml;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public abstract class ParameterWrapper
implements LoggableAPI {
    protected final String name;
    private final Map<String, Parameter<?>> parameters;
    UniversalParameters universals;

    protected ParameterWrapper(String name) {
        this(name, null);
    }

    protected ParameterWrapper(String name, MTDataRef.TableRef ref) {
        this.name = name;
        this.parameters = Collections.unmodifiableMap(this.initParameterMap(Objects.nonNull(ref) ? ref : this.getReferenceData()));
    }

    protected void addParameter(Map<String, Parameter<?>> map, String name, @Nullable Parameter<?> parameter) {
        if (Objects.nonNull(parameter = this.initParameter(name, parameter))) {
            map.put(name, parameter);
        }
    }

    protected Map<String, Object> asValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getValue());
        }
        return map;
    }

    public List<String> getBooleanParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            if (!(entry.getValue() instanceof ParameterBool)) continue;
            names.add(entry.getKey());
        }
        return names;
    }

    public Collection<DataLink> getChildWrappers(MTScreenInfo parent) {
        return Collections.emptySet();
    }

    public ParameterLink getLink() {
        return new ParameterLink(this, this.parameters);
    }

    protected abstract String getLogPrefix();

    @Nullable
    public Parameter<?> getParameter(String name) {
        Parameter<?> parameter = this.parameters.get(name.equals("id") ? "identifier" : name);
        if (this instanceof UniversalParameters || Objects.isNull(this.universals)) {
            return parameter;
        }
        Parameter<?> universal = this.universals.getParameter(name);
        return Objects.isNull(parameter) || Objects.nonNull(universal) && parameter.isDefault() ? universal : parameter;
    }

    public boolean getParameterAsBoolean(String name) {
        Parameter<?> parameter = this.getParameter(name);
        if (parameter instanceof ParameterBool) {
            return (Boolean)((ParameterBool)parameter).getValue();
        }
        if (parameter instanceof ParameterNumber) {
            return ((ParameterNumber)parameter).doubleValue() != 0.0;
        }
        return Objects.nonNull(parameter) && Boolean.parseBoolean(parameter.getValue().toString());
    }

    public byte getParameterAsByte(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::byteValue, s -> RandomHelper.randomByte((String)(name + "_as_number"), (String)s, (byte)0));
    }

    public double getParameterAsDouble(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::doubleValue, s -> RandomHelper.randomDouble((String)(name + "_as_number"), (String)s, (double)0.0));
    }

    public float getParameterAsFloat(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::floatValue, s -> Float.valueOf(RandomHelper.randomFloat((String)(name + "_as_number"), (String)s, (float)0.0f))).floatValue();
    }

    public int getParameterAsInt(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::intValue, s -> RandomHelper.randomInt((String)(name + "_as_number"), (String)s, (int)0));
    }

    public long getParameterAsLong(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::longValue, s -> RandomHelper.randomLong((String)(name + "_as_number"), (String)s, (long)0L));
    }

    public short getParameterAsShort(String name) {
        return this.getParameterAsNumber(this.getParameter(name), Number::shortValue, s -> RandomHelper.randomShort((String)(name + "_as_number"), (String)s, (short)0));
    }

    public List<?> getParameterAsList(String name) {
        Parameter<?> parameter = this.getParameter(name);
        if (Objects.isNull(parameter)) {
            this.logError("Unable to access list parameter `{}` that does not exist!", name);
            return Collections.emptyList();
        }
        if (!(parameter instanceof ParameterList)) {
            this.logWarn("Attempting to access non list parameter `{}` as a list! A singleton list will be substitured, but things may break!", name);
            return Collections.singletonList(parameter.getValue());
        }
        return (List)((ParameterList)parameter).getValue();
    }

    public Number getParameterAsNumber(String name) {
        return this.getParameterAsNumber(this.getParameter(name), n -> n, s -> RandomHelper.randomDouble((String)(name + "_as_number"), (String)s, (double)0.0));
    }

    protected <N extends Number> N getParameterAsNumber(Parameter<?> parameter, Function<Number, N> fromNumber, Function<String, N> fromString) {
        if (Objects.isNull(parameter)) {
            return (N)((Number)fromNumber.apply(0));
        }
        if (parameter instanceof ParameterNumber) {
            return (N)((Number)fromNumber.apply((Number)((ParameterNumber)parameter).getValue()));
        }
        if (parameter instanceof ParameterString) {
            return (N)((Number)fromString.apply((String)((ParameterString)parameter).getValue()));
        }
        if (parameter instanceof ParameterBool) {
            return (N)((Number)fromNumber.apply((Boolean)((ParameterBool)parameter).getValue() != false ? 1 : 0));
        }
        return this.getValueAsNumber(parameter.getValue(), fromNumber, fromString);
    }

    public String getParameterAsString(String name) {
        return String.valueOf(this.getParameter(name));
    }

    protected <N extends Number> N getValueAsNumber(Object value, Function<Number, N> fromNumber, Function<String, N> fromString) {
        if (Objects.isNull(value)) {
            return (N)((Number)fromNumber.apply(0));
        }
        if (value instanceof Number) {
            return (N)((Number)fromNumber.apply((Number)value));
        }
        if (value instanceof String) {
            return (N)((Number)fromString.apply((String)value));
        }
        if (value instanceof Boolean) {
            return (N)((Number)fromNumber.apply((Boolean)value != false ? 1 : 0));
        }
        if (value instanceof Iterable) {
            return this.getValueAsNumber(IterableHelper.getElement((int)0, (Iterable)((Collection)value)), fromNumber, fromString);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return this.getValueAsNumber(ArrayHelper.isNotEmpty((Object[])array) ? array[0] : Integer.valueOf(0), fromNumber, fromString);
        }
        return (N)((Number)fromString.apply(String.valueOf(value)));
    }

    public abstract MTDataRef.TableRef getReferenceData();

    public abstract Class<? extends ParameterWrapper> getTypeClass();

    public boolean hasAllNonDefaultParameter(String ... names) {
        for (String name : names) {
            if (this.hasNonDefaultParameter(name)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllParameters(String ... names) {
        for (String name : names) {
            if (this.hasParameter(name)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyNonDefaultParameter(String ... names) {
        for (String name : names) {
            if (!this.hasNonDefaultParameter(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyParameter(String ... names) {
        for (String name : names) {
            if (!this.hasParameter(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonDefaultParameter(String name) {
        Parameter<?> parameter = this.getParameter(name);
        return Objects.nonNull(parameter) && !parameter.isDefault();
    }

    public boolean hasParameter(String name) {
        return Objects.nonNull(this.getParameter(name));
    }

    protected void inheritParameters(ParameterWrapper wrapper) {
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            Parameter<?> other = wrapper.getParameter(entry.getKey());
            if (!Objects.nonNull(other)) continue;
            entry.getValue().setValue(other.getValue());
        }
    }

    protected Map<String, Parameter<?>> initParameterMap(MTDataRef.TableRef table) {
        HashMap map = new HashMap();
        if (Objects.nonNull(table)) {
            for (MTDataRef.ParameterRef<?> ref : table.getParameters()) {
                this.addParameter(map, ref.getName(), ref.toParameter());
            }
        }
        this.initExtraParameters(map);
        return map;
    }

    @Nullable
    protected Parameter<?> initParameter(String parameter, Parameter<?> defaultParameter) {
        return defaultParameter;
    }

    protected void initExtraParameters(Map<String, Parameter<?>> map) {
    }

    @Override
    public void logDebug(String message, Object ... args) {
        MTLogger.logDebug(this.getLogPrefix(), this.getName(), message, args);
    }

    @Override
    public void logError(String message, Object ... args) {
        MTLogger.logError(this.getLogPrefix(), this.getName(), message, args);
    }

    @Override
    public void logFatal(String message, Object ... args) {
        MTLogger.logFatal(this.getLogPrefix(), this.getName(), message, args);
    }

    @Override
    public void logInfo(String message, Object ... args) {
        MTLogger.logInfo(this.getLogPrefix(), this.getName(), message, args);
    }

    protected void logMissingParameter(String name) {
        this.logError("Missing required `{}` parameter!", name);
    }

    protected void logMissingParameters(String ... names) {
        this.logError("Missing 1 or more required parameters from [{}]! (All of these are required)", TextHelper.arrayToString((String)", ", (Object[])names));
    }

    protected void logMissingPotentialParameter(String ... names) {
        this.logError("Missing a required parameter from [{}]! (Only 1 of these is required)", TextHelper.arrayToString((String)", ", (Object[])names));
    }

    @Override
    public void logTrace(String message, Object ... args) {
        MTLogger.logTrace(this.getLogPrefix(), this.getName(), message, args);
    }

    @Override
    public void logWarn(String message, Object ... args) {
        MTLogger.logWarn(this.getLogPrefix(), this.getName(), message, args);
    }

    public boolean matchesAll(ParameterWrapper wrapper) {
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            if (GenericUtils.matches(entry.getValue(), wrapper.getParameter(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean parse(Toml table) {
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            if ("identifier".equals(name)) {
                String value;
                boolean hasShort = table.hasEntry("id");
                String string = table.hasEntry("identifier") ? table.getValueString("identifier") : (value = hasShort ? table.getValueString("id") : null);
                if (Objects.nonNull(value)) {
                    String filter = this.getName().toLowerCase() + "-";
                    while (value.toLowerCase().contains(filter)) {
                        int index = value.indexOf(filter);
                        value = value.substring(index, index + filter.length());
                    }
                    table.addEntry("identifier", (Object)value);
                    if (hasShort) {
                        table.removeEntry("id");
                    }
                }
            }
            if (!table.hasEntry(name)) continue;
            Parameter<?> parameter = entry.getValue();
            this.setParameterValue(name, table.getValue(name), parameter);
        }
        return this.verifyRequiredParameters();
    }

    public boolean parseTriggers(ChannelHelper helper, String channel, Collection<TriggerAPI> triggers) {
        return this.parseTriggers(true, helper, channel, triggers, "triggers");
    }

    public boolean parseTriggers(boolean implyMissing, ChannelHelper helper, String channel, Collection<TriggerAPI> triggers) {
        return this.parseTriggers(implyMissing, helper, channel, triggers, "triggers");
    }

    public boolean parseTriggers(ChannelHelper helper, String channel, Collection<TriggerAPI> triggers, String parameterName) {
        return this.parseTriggers(true, helper.findChannel(this, channel), triggers, parameterName);
    }

    public boolean parseTriggers(boolean implyMissing, ChannelHelper helper, String channel, Collection<TriggerAPI> triggers, String parameterName) {
        return this.parseTriggers(implyMissing, helper.findChannel(this, channel), triggers, parameterName);
    }

    public boolean parseTriggers(ChannelAPI channel, Collection<TriggerAPI> triggers) {
        return this.parseTriggers(true, channel, triggers, "triggers");
    }

    public boolean parseTriggers(boolean implyMissing, ChannelAPI channel, Collection<TriggerAPI> triggers) {
        return this.parseTriggers(implyMissing, channel, triggers, "triggers");
    }

    public boolean parseTriggers(ChannelAPI channel, Collection<TriggerAPI> triggers, String parameterName) {
        return this.parseTriggers(true, channel, triggers, this.getParameterAsList(parameterName));
    }

    public boolean parseTriggers(boolean implyMissing, ChannelAPI channel, Collection<TriggerAPI> triggers, String parameterName) {
        return this.parseTriggers(implyMissing, channel, triggers, this.getParameterAsList(parameterName));
    }

    protected boolean parseTriggers(ChannelAPI channel, Collection<TriggerAPI> triggers, Collection<?> triggerRefs) {
        return this.parseTriggers(true, channel, triggers, triggerRefs);
    }

    protected boolean parseTriggers(boolean implyMissing, ChannelAPI channel, Collection<TriggerAPI> triggers, Collection<?> triggerRefs) {
        if (!TriggerHelper.findTriggers(implyMissing, channel, triggers, triggerRefs)) {
            this.logError("Failed to parse 1 or more triggers!", new Object[0]);
            return false;
        }
        if (triggers.isEmpty()) {
            this.logDebug("No triggers were found! Attempting to load anyways", new Object[0]);
        }
        return true;
    }

    protected <T> void setParameterValue(String name, T value, @Nullable Parameter<?> parameter) {
        if (Objects.nonNull(parameter)) {
            parameter.setValue(value);
        } else {
            this.logWarn("Cannot set value for paramenter `{}` that does not exist in {}!", name, this.getLogPrefix());
        }
    }

    public String toString() {
        return this.getLogPrefix() + "[" + this.getName() + "]";
    }

    public Toml toToml() {
        Toml toml = Toml.getEmpty();
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            toml.addEntry(entry.getKey(), entry.getValue().getValue());
        }
        return this.toTomlExtra(toml);
    }

    protected Toml toTomlExtra(Toml toml) {
        return toml;
    }

    public boolean verifyRequiredParameters() {
        MTDataRef.TableRef table = this.getReferenceData();
        if (Objects.isNull(table)) {
            return true;
        }
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            String name = entry.getKey();
            MTDataRef.ParameterRef<?> ref = table.findParameter(name);
            Object value = entry.getValue().getValue();
            if (Objects.isNull(ref) || ref.isValid(value)) continue;
            this.logError("`{}` is not a valid value for the parameter {}!", value, name);
            return false;
        }
        return true;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setUniversals(UniversalParameters universals) {
        this.universals = universals;
    }

    @Generated
    public UniversalParameters getUniversals() {
        return this.universals;
    }
}

