/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.parameter;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterList;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterString;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterBool;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterByte;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterDouble;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterFloat;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterInt;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterLong;
import mods.thecomputerizer.musictriggers.api.data.parameter.primitive.ParameterShort;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;

public class ParameterHelper {
    public static <E> Parameter<E> parameterize(Class<E> type, E element) {
        if (Collection.class.isAssignableFrom(type)) {
            return new ParameterList<String>(String.class, (List)element);
        }
        switch (type.getSimpleName()) {
            case "Boolean": {
                return new ParameterBool((Boolean)element);
            }
            case "Byte": {
                return new ParameterByte((Byte)element);
            }
            case "Double": {
                return new ParameterDouble((Double)element);
            }
            case "Float": {
                return new ParameterFloat(((Float)element).floatValue());
            }
            case "Integer": {
                return new ParameterInt((Integer)element);
            }
            case "Long": {
                return new ParameterLong((Long)element);
            }
            case "Short": {
                return new ParameterShort((Short)element);
            }
        }
        return new ParameterString((String)element);
    }

    @Nullable
    public static Parameter<?> parse(ByteBuf buf) {
        Class clazz = ReflectionHelper.findExtensibleClass((String)NetworkHelper.readString((ByteBuf)buf), Parameter.class);
        Constructor constructor = ReflectionHelper.findConstructor((Class)clazz, (Class[])new Class[]{ByteBuf.class});
        try {
            return (Parameter)constructor.newInstance(buf);
        }
        catch (ReflectiveOperationException ex) {
            MTRef.logError("Unable to invoke constructor `{}` for paremter!", constructor);
            return null;
        }
    }
}

