/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.parameter;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;

public abstract class Parameter<T> {
    protected final T defaultValue;
    protected T value;

    protected Parameter(T defaultValue) {
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    protected Parameter(ByteBuf buf) {
        this.defaultValue = this.read(buf);
        this.value = this.read(buf);
    }

    public abstract Parameter<T> copy();

    public boolean equals(Object other) {
        return other instanceof Parameter && GenericUtils.matches(this.value, ((Parameter)other).value);
    }

    public abstract boolean isBool();

    public abstract boolean isByte();

    public boolean isDefault() {
        return GenericUtils.matches(this.value, this.defaultValue);
    }

    public abstract boolean isDouble();

    public abstract boolean isFloat();

    public abstract boolean isInt();

    public abstract boolean isList();

    public abstract boolean isLong();

    public abstract boolean isNumber();

    public abstract boolean isPrimitive();

    public abstract boolean isShort();

    public abstract boolean isString();

    protected abstract T read(ByteBuf var1);

    public abstract void setValue(@Nullable Object var1);

    public String toString() {
        return String.valueOf(this.value);
    }

    public void write(ByteBuf buf) {
        NetworkHelper.writeString((ByteBuf)buf, (String)this.getClass().getName());
        this.write(buf, this.defaultValue);
        this.write(buf, this.value);
    }

    protected abstract void write(ByteBuf var1, T var2);

    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public T getValue() {
        return this.value;
    }
}

